/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.nuklear.NkColor;
import org.lwjgl.nuklear.NkImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="union nk_style_item_data")
public class NkStyleItemData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int COLOR;

    public NkStyleItemData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkStyleItemData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct nk_image")
    public NkImage image() {
        return NkStyleItemData.nimage(this.address());
    }

    @NativeType(value="struct nk_color")
    public NkColor color() {
        return NkStyleItemData.ncolor(this.address());
    }

    public NkStyleItemData image(@NativeType(value="struct nk_image") NkImage value) {
        NkStyleItemData.nimage(this.address(), value);
        return this;
    }

    public NkStyleItemData image(Consumer<NkImage> consumer) {
        consumer.accept(this.image());
        return this;
    }

    public NkStyleItemData color(@NativeType(value="struct nk_color") NkColor value) {
        NkStyleItemData.ncolor(this.address(), value);
        return this;
    }

    public NkStyleItemData color(Consumer<NkColor> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public NkStyleItemData set(NkStyleItemData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkStyleItemData malloc() {
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkStyleItemData calloc() {
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkStyleItemData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkStyleItemData create(long address) {
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)address);
    }

    @Nullable
    public static NkStyleItemData createSafe(long address) {
        return address == 0L ? null : (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkStyleItemData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkStyleItemData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkStyleItemData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkStyleItemData mallocStack() {
        return NkStyleItemData.mallocStack(MemoryStack.stackGet());
    }

    public static NkStyleItemData callocStack() {
        return NkStyleItemData.callocStack(MemoryStack.stackGet());
    }

    public static NkStyleItemData mallocStack(MemoryStack stack) {
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkStyleItemData callocStack(MemoryStack stack) {
        return (NkStyleItemData)NkStyleItemData.wrap(NkStyleItemData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkStyleItemData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkStyleItemData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkStyleItemData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static NkImage nimage(long struct) {
        return NkImage.create(struct + (long)IMAGE);
    }

    public static NkColor ncolor(long struct) {
        return NkColor.create(struct + (long)COLOR);
    }

    public static void nimage(long struct, NkImage value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)IMAGE), (long)NkImage.SIZEOF);
    }

    public static void ncolor(long struct, NkColor value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)COLOR), (long)NkColor.SIZEOF);
    }

    static {
        Struct.Layout layout = NkStyleItemData.__union((Struct.Member[])new Struct.Member[]{NkStyleItemData.__member((int)NkImage.SIZEOF, (int)NkImage.ALIGNOF), NkStyleItemData.__member((int)NkColor.SIZEOF, (int)NkColor.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        COLOR = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkStyleItemData, Buffer>
    implements NativeResource {
        private static final NkStyleItemData ELEMENT_FACTORY = NkStyleItemData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkStyleItemData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct nk_image")
        public NkImage image() {
            return NkStyleItemData.nimage(this.address());
        }

        @NativeType(value="struct nk_color")
        public NkColor color() {
            return NkStyleItemData.ncolor(this.address());
        }

        public Buffer image(@NativeType(value="struct nk_image") NkImage value) {
            NkStyleItemData.nimage(this.address(), value);
            return this;
        }

        public Buffer image(Consumer<NkImage> consumer) {
            consumer.accept(this.image());
            return this;
        }

        public Buffer color(@NativeType(value="struct nk_color") NkColor value) {
            NkStyleItemData.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<NkColor> consumer) {
            consumer.accept(this.color());
            return this;
        }
    }
}

