/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_memory_status")
public class NkMemoryStatus
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MEMORY;
    public static final int TYPE;
    public static final int SIZE;
    public static final int ALLOCATED;
    public static final int NEEDED;
    public static final int CALLS;

    public NkMemoryStatus(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkMemoryStatus.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public ByteBuffer memory() {
        return NkMemoryStatus.nmemory(this.address());
    }

    @NativeType(value="unsigned int")
    public int type() {
        return NkMemoryStatus.ntype(this.address());
    }

    @NativeType(value="nk_size")
    public long size() {
        return NkMemoryStatus.nsize(this.address());
    }

    @NativeType(value="nk_size")
    public long allocated() {
        return NkMemoryStatus.nallocated(this.address());
    }

    @NativeType(value="nk_size")
    public long needed() {
        return NkMemoryStatus.nneeded(this.address());
    }

    @NativeType(value="nk_size")
    public long calls() {
        return NkMemoryStatus.ncalls(this.address());
    }

    public static NkMemoryStatus malloc() {
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkMemoryStatus calloc() {
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkMemoryStatus create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkMemoryStatus create(long address) {
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)address);
    }

    @Nullable
    public static NkMemoryStatus createSafe(long address) {
        return address == 0L ? null : (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkMemoryStatus.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkMemoryStatus.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkMemoryStatus mallocStack() {
        return NkMemoryStatus.mallocStack(MemoryStack.stackGet());
    }

    public static NkMemoryStatus callocStack() {
        return NkMemoryStatus.callocStack(MemoryStack.stackGet());
    }

    public static NkMemoryStatus mallocStack(MemoryStack stack) {
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkMemoryStatus callocStack(MemoryStack stack) {
        return (NkMemoryStatus)NkMemoryStatus.wrap(NkMemoryStatus.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkMemoryStatus.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkMemoryStatus.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkMemoryStatus.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nmemory(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)MEMORY)), (int)((int)NkMemoryStatus.nsize(struct)));
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static long nallocated(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ALLOCATED));
    }

    public static long nneeded(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEEDED));
    }

    public static long ncalls(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CALLS));
    }

    static {
        Struct.Layout layout = NkMemoryStatus.__struct((Struct.Member[])new Struct.Member[]{NkMemoryStatus.__member((int)POINTER_SIZE), NkMemoryStatus.__member((int)4), NkMemoryStatus.__member((int)POINTER_SIZE), NkMemoryStatus.__member((int)POINTER_SIZE), NkMemoryStatus.__member((int)POINTER_SIZE), NkMemoryStatus.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MEMORY = layout.offsetof(0);
        TYPE = layout.offsetof(1);
        SIZE = layout.offsetof(2);
        ALLOCATED = layout.offsetof(3);
        NEEDED = layout.offsetof(4);
        CALLS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<NkMemoryStatus, Buffer>
    implements NativeResource {
        private static final NkMemoryStatus ELEMENT_FACTORY = NkMemoryStatus.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkMemoryStatus getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public ByteBuffer memory() {
            return NkMemoryStatus.nmemory(this.address());
        }

        @NativeType(value="unsigned int")
        public int type() {
            return NkMemoryStatus.ntype(this.address());
        }

        @NativeType(value="nk_size")
        public long size() {
            return NkMemoryStatus.nsize(this.address());
        }

        @NativeType(value="nk_size")
        public long allocated() {
            return NkMemoryStatus.nallocated(this.address());
        }

        @NativeType(value="nk_size")
        public long needed() {
            return NkMemoryStatus.nneeded(this.address());
        }

        @NativeType(value="nk_size")
        public long calls() {
            return NkMemoryStatus.ncalls(this.address());
        }
    }
}

