/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Meshlet")
public class MeshoptMeshlet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTICES;
    public static final int INDICES;
    public static final int TRIANGLE_COUNT;
    public static final int VERTEX_COUNT;

    public MeshoptMeshlet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), MeshoptMeshlet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int[64]")
    public IntBuffer vertices() {
        return MeshoptMeshlet.nvertices(this.address());
    }

    @NativeType(value="unsigned int")
    public int vertices(int index) {
        return MeshoptMeshlet.nvertices(this.address(), index);
    }

    @NativeType(value="unsigned char[126][3]")
    public ByteBuffer indices() {
        return MeshoptMeshlet.nindices(this.address());
    }

    @NativeType(value="unsigned char")
    public byte indices(int index) {
        return MeshoptMeshlet.nindices(this.address(), index);
    }

    @NativeType(value="unsigned char")
    public byte triangle_count() {
        return MeshoptMeshlet.ntriangle_count(this.address());
    }

    @NativeType(value="unsigned char")
    public byte vertex_count() {
        return MeshoptMeshlet.nvertex_count(this.address());
    }

    public static MeshoptMeshlet malloc() {
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static MeshoptMeshlet calloc() {
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static MeshoptMeshlet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static MeshoptMeshlet create(long address) {
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)address);
    }

    @Nullable
    public static MeshoptMeshlet createSafe(long address) {
        return address == 0L ? null : (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)MeshoptMeshlet.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptMeshlet.__create((int)capacity, (int)SIZEOF);
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static MeshoptMeshlet mallocStack() {
        return MeshoptMeshlet.mallocStack(MemoryStack.stackGet());
    }

    public static MeshoptMeshlet callocStack() {
        return MeshoptMeshlet.callocStack(MemoryStack.stackGet());
    }

    public static MeshoptMeshlet mallocStack(MemoryStack stack) {
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptMeshlet callocStack(MemoryStack stack) {
        return (MeshoptMeshlet)MeshoptMeshlet.wrap(MeshoptMeshlet.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return MeshoptMeshlet.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return MeshoptMeshlet.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)MeshoptMeshlet.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static IntBuffer nvertices(long struct) {
        return MemoryUtil.memIntBuffer((long)(struct + (long)VERTICES), (int)64);
    }

    public static int nvertices(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)VERTICES + Checks.check((int)index, (int)64) * 4L);
    }

    public static ByteBuffer nindices(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)INDICES), (int)378);
    }

    public static byte nindices(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)INDICES + Checks.check((int)index, (int)378) * 1L);
    }

    public static byte ntriangle_count(long struct) {
        return UNSAFE.getByte(null, struct + (long)TRIANGLE_COUNT);
    }

    public static byte nvertex_count(long struct) {
        return UNSAFE.getByte(null, struct + (long)VERTEX_COUNT);
    }

    static {
        Struct.Layout layout = MeshoptMeshlet.__struct((Struct.Member[])new Struct.Member[]{MeshoptMeshlet.__array((int)4, (int)64), MeshoptMeshlet.__array((int)1, (int)378), MeshoptMeshlet.__member((int)1), MeshoptMeshlet.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTICES = layout.offsetof(0);
        INDICES = layout.offsetof(1);
        TRIANGLE_COUNT = layout.offsetof(2);
        VERTEX_COUNT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MeshoptMeshlet, Buffer>
    implements NativeResource {
        private static final MeshoptMeshlet ELEMENT_FACTORY = MeshoptMeshlet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected MeshoptMeshlet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int[64]")
        public IntBuffer vertices() {
            return MeshoptMeshlet.nvertices(this.address());
        }

        @NativeType(value="unsigned int")
        public int vertices(int index) {
            return MeshoptMeshlet.nvertices(this.address(), index);
        }

        @NativeType(value="unsigned char[126][3]")
        public ByteBuffer indices() {
            return MeshoptMeshlet.nindices(this.address());
        }

        @NativeType(value="unsigned char")
        public byte indices(int index) {
            return MeshoptMeshlet.nindices(this.address(), index);
        }

        @NativeType(value="unsigned char")
        public byte triangle_count() {
            return MeshoptMeshlet.ntriangle_count(this.address());
        }

        @NativeType(value="unsigned char")
        public byte vertex_count() {
            return MeshoptMeshlet.nvertex_count(this.address());
        }
    }
}

