/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.logstash.plugins.inputs.http.HttpServerHandler;
import org.logstash.plugins.inputs.http.IMessageHandler;
import org.logstash.plugins.inputs.http.util.SslHandlerProvider;

public class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private final IMessageHandler messageHandler;
    private SslHandlerProvider sslHandlerProvider;
    private final int maxContentLength;
    private final HttpResponseStatus responseStatus;
    private final ThreadPoolExecutor executorGroup;

    public HttpInitializer(IMessageHandler messageHandler, ThreadPoolExecutor executorGroup, int maxContentLength, HttpResponseStatus responseStatus) {
        this.messageHandler = messageHandler;
        this.executorGroup = executorGroup;
        this.maxContentLength = maxContentLength;
        this.responseStatus = responseStatus;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        if (this.sslHandlerProvider != null) {
            SslHandler sslHandler = this.sslHandlerProvider.getSslHandler(socketChannel.alloc());
            pipeline.addLast(new ChannelHandler[]{sslHandler});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxContentLength)});
        pipeline.addLast(new ChannelHandler[]{new HttpServerHandler(this.messageHandler.copy(), this.executorGroup, this.responseStatus)});
    }

    public void enableSSL(SslHandlerProvider sslHandlerProvider) {
        this.sslHandlerProvider = sslHandlerProvider;
    }
}

