/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PluginClassLoader
extends URLClassLoader {
    private ClassLoader appClassLoader;

    private PluginClassLoader(URL[] urls, ClassLoader appClassLoader) {
        super(urls, (ClassLoader)null);
        this.appClassLoader = appClassLoader;
    }

    public static PluginClassLoader create(String gemPath, String jarPath, ClassLoader appClassLoader) {
        String pluginPath = gemPath.substring(0, gemPath.lastIndexOf(File.separator)) + File.separator + jarPath;
        Path pluginJar = Paths.get(pluginPath, new String[0]);
        if (!Files.exists(pluginJar, new LinkOption[0])) {
            throw new IllegalStateException("PluginClassLoader unable to locate jar file: " + pluginPath);
        }
        try {
            URL[] pluginJarUrl = new URL[]{pluginJar.toUri().toURL()};
            return new PluginClassLoader(pluginJarUrl, appClassLoader);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (!name.startsWith("co.elastic.logstash.") && !name.startsWith("org.logstash.")) {
                if (c == null) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        c = super.loadClass(name, resolve);
                    }
                }
            } else {
                c = this.appClassLoader.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

