/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.Immutable;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.ModifierOrderer;
import com.google.googlejavaformat.java.Replacement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Message;

@Immutable
public final class Formatter {
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(-1));
    private final JavaFormatterOptions options;
    static final CharMatcher NEWLINE = CharMatcher.is((char)'\n');

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) throws FormatterException {
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(javaInput.getText().toCharArray());
        Hashtable parserOptions = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)parserOptions);
        parser.setCompilerOptions((Map)parserOptions);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        javaInput.setCompilationUnit(unit);
        if (unit.getMessages().length > 0) {
            ArrayList<FormatterDiagnostic> errors = new ArrayList<FormatterDiagnostic>();
            for (Message message : unit.getMessages()) {
                errors.add(javaInput.createDiagnostic(message.getStartPosition(), message.getMessage()));
            }
            throw new FormatterException(errors);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        new JavaInputAstVisitor(builder, options.indentationMultiplier()).visit(unit);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps((List<Op>)builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.maxLineLength(), new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write((CharSequence)this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, Collections.singleton(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(input.length()))));
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return JavaOutput.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        input = ModifierOrderer.reorderModifiers(input, characterRanges);
        JavaInput javaInput = new JavaInput(input);
        JavaOutput javaOutput = new JavaOutput(javaInput, new JavaCommentsHelper(this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException(e.diagnostic());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        lines.add(0);
        int idx = NEWLINE.indexIn((CharSequence)input);
        while (idx >= 0) {
            lines.add(idx + 1);
            idx = NEWLINE.indexIn((CharSequence)input, idx + 1);
        }
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : lineRanges.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lines.size() - 1))).asRanges()) {
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range range = Range.closedOpen((Comparable)Integer.valueOf(lineStart), (Comparable)Integer.valueOf(lineEnd));
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

