/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.AbstractTypeConstraint;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBound;
import jadx.core.dex.visitors.typeinference.ITypeConstraint;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.dex.visitors.typeinference.TypeSearchState;
import jadx.core.dex.visitors.typeinference.TypeSearchVarInfo;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSearch {
    private static final Logger LOG = LoggerFactory.getLogger(TypeSearch.class);
    private static final int CANDIDATES_COUNT_LIMIT = 10;
    private static final int SEARCH_ITERATION_LIMIT = 1000000;
    private final MethodNode mth;
    private final TypeSearchState state;
    private final TypeCompare typeCompare;
    private final TypeUpdate typeUpdate;

    public TypeSearch(MethodNode mth) {
        this.mth = mth;
        this.state = new TypeSearchState(mth);
        this.typeUpdate = mth.root().getTypeUpdate();
        this.typeCompare = this.typeUpdate.getTypeCompare();
    }

    public boolean run() {
        boolean searchSuccess;
        this.mth.getSVars().forEach(this::fillTypeCandidates);
        this.mth.getSVars().forEach(this::collectConstraints);
        this.state.getUnresolvedVars().forEach(this::resolveIndependentVariables);
        List<TypeSearchVarInfo> vars = this.state.getUnresolvedVars();
        if (vars.isEmpty()) {
            searchSuccess = true;
        } else {
            this.search(vars);
            searchSuccess = this.fullCheck(vars);
        }
        boolean applySuccess = this.applyResolvedVars();
        return searchSuccess && applySuccess;
    }

    private boolean applyResolvedVars() {
        List<TypeSearchVarInfo> resolvedVars = this.state.getResolvedVars();
        for (TypeSearchVarInfo var : resolvedVars) {
            SSAVar ssaVar = var.getVar();
            ArgType resolvedType = var.getCurrentType();
            ssaVar.setType(resolvedType);
        }
        boolean applySuccess = true;
        for (TypeSearchVarInfo var : resolvedVars) {
            TypeUpdateResult res;
            if (!var.getCurrentType().isTypeKnown() || (res = this.typeUpdate.applyWithWiderIgnSame(var.getVar(), var.getCurrentType())) != TypeUpdateResult.REJECT) continue;
            this.mth.addComment("JADX DEBUG: Multi-variable search result rejected for " + var);
            applySuccess = false;
        }
        return applySuccess;
    }

    private boolean search(List<TypeSearchVarInfo> vars) {
        int len = vars.size();
        for (TypeSearchVarInfo var : vars) {
            var.reset();
        }
        int n = 0;
        int i = 0;
        while (!this.fullCheck(vars)) {
            TypeSearchVarInfo first = vars.get(i);
            if (first.nextType()) {
                int k = i + 1;
                if (k >= len) {
                    return false;
                }
                TypeSearchVarInfo next = vars.get(k);
                while (next.nextType()) {
                    if (++k >= len) {
                        return false;
                    }
                    next = vars.get(k);
                }
            }
            if (++n <= 1000000) continue;
            return false;
        }
        for (TypeSearchVarInfo var : vars) {
            var.setTypeResolved(true);
        }
        return true;
    }

    private boolean resolveIndependentVariables(TypeSearchVarInfo varInfo) {
        boolean allRelatedVarsResolved = varInfo.getConstraints().stream().flatMap(c -> c.getRelatedVars().stream()).allMatch(v -> this.state.getVarInfo((SSAVar)v).isTypeResolved());
        if (!allRelatedVarsResolved) {
            return false;
        }
        varInfo.reset();
        do {
            if (!this.singleCheck(varInfo)) continue;
            varInfo.setTypeResolved(true);
            return true;
        } while (!varInfo.nextType());
        return false;
    }

    private boolean fullCheck(List<TypeSearchVarInfo> vars) {
        for (TypeSearchVarInfo var : vars) {
            if (this.singleCheck(var)) continue;
            return false;
        }
        return true;
    }

    private boolean singleCheck(TypeSearchVarInfo var) {
        if (var.isTypeResolved()) {
            return true;
        }
        for (ITypeConstraint constraint : var.getConstraints()) {
            if (constraint.check(this.state)) continue;
            return false;
        }
        return true;
    }

    private void fillTypeCandidates(SSAVar ssaVar) {
        TypeSearchVarInfo varInfo = this.state.getVarInfo(ssaVar);
        ArgType immutableType = ssaVar.getImmutableType();
        if (immutableType != null) {
            varInfo.markResolved(immutableType);
            return;
        }
        ArgType currentType = ssaVar.getTypeInfo().getType();
        if (currentType.isTypeKnown()) {
            varInfo.markResolved(currentType);
            return;
        }
        LinkedHashSet<ArgType> assigns = new LinkedHashSet<ArgType>();
        LinkedHashSet<ArgType> uses = new LinkedHashSet<ArgType>();
        Set<ITypeBound> bounds = ssaVar.getTypeInfo().getBounds();
        for (ITypeBound iTypeBound : bounds) {
            if (iTypeBound.getBound() == BoundEnum.ASSIGN) {
                assigns.add(iTypeBound.getType());
                continue;
            }
            uses.add(iTypeBound.getType());
        }
        LinkedHashSet<ArgType> candidateTypes = new LinkedHashSet<ArgType>();
        this.addCandidateTypes(bounds, candidateTypes, assigns);
        this.addCandidateTypes(bounds, candidateTypes, uses);
        for (ArgType assignType : assigns) {
            this.addCandidateTypes(bounds, candidateTypes, this.getWiderTypes(assignType));
        }
        for (ArgType useType : uses) {
            this.addCandidateTypes(bounds, candidateTypes, this.getNarrowTypes(useType));
        }
        this.addUsageTypeCandidates(ssaVar, bounds, candidateTypes);
        int n = candidateTypes.size();
        if (n == 0) {
            varInfo.setTypeResolved(true);
            varInfo.setCurrentType(ArgType.UNKNOWN);
            varInfo.setCandidateTypes(Collections.emptyList());
        } else if (n == 1) {
            varInfo.setTypeResolved(true);
            varInfo.setCurrentType((ArgType)candidateTypes.iterator().next());
            varInfo.setCandidateTypes(Collections.emptyList());
        } else {
            varInfo.setTypeResolved(false);
            varInfo.setCurrentType(ArgType.UNKNOWN);
            ArrayList<ArgType> types = new ArrayList<ArgType>(candidateTypes);
            types.sort(this.typeCompare.getReversedComparator());
            varInfo.setCandidateTypes(Collections.unmodifiableList(types));
        }
    }

    private void addUsageTypeCandidates(SSAVar ssaVar, Set<ITypeBound> bounds, Set<ArgType> candidateTypes) {
        for (RegisterArg useArg : ssaVar.getUseList()) {
            ArgType aputType;
            InsnType insnType;
            InsnNode parentInsn = useArg.getParentInsn();
            if (parentInsn == null || (insnType = parentInsn.getType()) != InsnType.APUT || !(aputType = parentInsn.getArg(2).getType()).isTypeKnown()) continue;
            this.addCandidateType(bounds, candidateTypes, ArgType.array(aputType));
        }
    }

    private void addCandidateTypes(Set<ITypeBound> bounds, Set<ArgType> collectedTypes, Collection<ArgType> candidateTypes) {
        for (ArgType candidateType : candidateTypes) {
            if (!this.addCandidateType(bounds, collectedTypes, candidateType)) continue;
            return;
        }
    }

    private boolean addCandidateType(Set<ITypeBound> bounds, Set<ArgType> collectedTypes, ArgType candidateType) {
        if (candidateType.isTypeKnown() && this.typeUpdate.inBounds(bounds, candidateType)) {
            collectedTypes.add(candidateType);
            if (collectedTypes.size() > 10) {
                return true;
            }
        }
        return false;
    }

    private List<ArgType> getWiderTypes(ArgType type) {
        if (type.isTypeKnown()) {
            if (type.isObject()) {
                Set<String> ancestors = this.mth.root().getClsp().getAncestors(type.getObject());
                return ancestors.stream().map(ArgType::object).collect(Collectors.toList());
            }
        } else {
            return this.expandUnknownType(type);
        }
        return Collections.emptyList();
    }

    private List<ArgType> getNarrowTypes(ArgType type) {
        if (type.isTypeKnown()) {
            if (type.isObject()) {
                if (type.equals(ArgType.OBJECT)) {
                    return Collections.singletonList(ArgType.OBJECT);
                }
                List<String> impList = this.mth.root().getClsp().getImplementations(type.getObject());
                return impList.stream().map(ArgType::object).collect(Collectors.toList());
            }
        } else {
            return this.expandUnknownType(type);
        }
        return Collections.emptyList();
    }

    private List<ArgType> expandUnknownType(ArgType type) {
        ArrayList<ArgType> list = new ArrayList<ArgType>();
        for (PrimitiveType possibleType : type.getPossibleTypes()) {
            list.add(ArgType.convertFromPrimitiveType(possibleType));
        }
        return list;
    }

    private void collectConstraints(SSAVar var) {
        TypeSearchVarInfo varInfo = this.state.getVarInfo(var);
        if (varInfo.isTypeResolved()) {
            varInfo.setConstraints(Collections.emptyList());
            return;
        }
        varInfo.setConstraints(new ArrayList<ITypeConstraint>());
        this.addConstraint(varInfo, this.makeConstraint(var.getAssign()));
        for (RegisterArg regArg : var.getUseList()) {
            this.addConstraint(varInfo, this.makeConstraint(regArg));
        }
    }

    private void addConstraint(TypeSearchVarInfo varInfo, ITypeConstraint constraint) {
        if (constraint != null) {
            varInfo.getConstraints().add(constraint);
        }
    }

    @Nullable
    private ITypeConstraint makeConstraint(RegisterArg arg) {
        InsnNode insn = arg.getParentInsn();
        if (insn == null || arg.isTypeImmutable()) {
            return null;
        }
        switch (insn.getType()) {
            case MOVE: {
                return this.makeMoveConstraint(insn, arg);
            }
            case PHI: {
                return this.makePhiConstraint(insn, arg);
            }
        }
        return null;
    }

    @Nullable
    private ITypeConstraint makeMoveConstraint(InsnNode insn, RegisterArg arg) {
        if (!insn.getArg(0).isRegister()) {
            return null;
        }
        return new AbstractTypeConstraint(insn, arg){

            @Override
            public boolean check(TypeSearchState state) {
                ArgType resType = state.getArgType(this.insn.getResult());
                ArgType argType = state.getArgType(this.insn.getArg(0));
                TypeCompareEnum res = TypeSearch.this.typeCompare.compareTypes(resType, argType);
                return res.isEqual() || res.isWider();
            }
        };
    }

    private ITypeConstraint makePhiConstraint(InsnNode insn, RegisterArg arg) {
        return new AbstractTypeConstraint(insn, arg){

            @Override
            public boolean check(TypeSearchState state) {
                ArgType resType = state.getArgType(this.insn.getResult());
                for (InsnArg insnArg : this.insn.getArguments()) {
                    ArgType argType = state.getArgType(insnArg);
                    if (argType.equals(resType)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

