/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.unix.Pty;
import java.io.IOException;
import java.io.OutputStream;

public class PTYOutputStream
extends OutputStream {
    Pty myPty;

    public PTYOutputStream(Pty pty) {
        this.myPty = pty;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] tmpBuf = new byte[len];
        System.arraycopy(b, off, tmpBuf, off, len);
        this.myPty.write(tmpBuf, len);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.myPty.close();
    }
}

