/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompilerManager {
    public static final Key<RunConfiguration> RUN_CONFIGURATION_KEY = Key.create((String)"RUN_CONFIGURATION");
    public static final Key<String> RUN_CONFIGURATION_TYPE_ID_KEY = Key.create((String)"RUN_CONFIGURATION_TYPE_ID");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Compiler");

    public static CompilerManager getInstance(@NotNull Project project) {
        if (project == null) {
            CompilerManager.$$$reportNull$$$0(0);
        }
        return (CompilerManager)project.getService(CompilerManager.class);
    }

    public abstract boolean isCompilationActive();

    @Deprecated
    public abstract void addCompiler(@NotNull Compiler var1);

    @Deprecated
    public abstract void addTranslatingCompiler(@NotNull TranslatingCompiler var1, Set<FileType> var2, Set<FileType> var3);

    @Deprecated
    public abstract void removeCompiler(@NotNull Compiler var1);

    public abstract <T extends Compiler> T @NotNull [] getCompilers(@NotNull Class<T> var1);

    @Deprecated
    public abstract void addCompilableFileType(@NotNull FileType var1);

    @Deprecated
    public abstract void removeCompilableFileType(@NotNull FileType var1);

    public abstract boolean isCompilableFileType(@NotNull FileType var1);

    public abstract void addBeforeTask(@NotNull CompileTask var1);

    @Deprecated
    public abstract void addAfterTask(@NotNull CompileTask var1);

    @NotNull
    public abstract List<CompileTask> getBeforeTasks();

    @Deprecated
    public CompileTask @NotNull [] getAfterTasks() {
        CompileTask[] compileTaskArray = this.getAfterTaskList().toArray(new CompileTask[0]);
        if (compileTaskArray == null) {
            CompilerManager.$$$reportNull$$$0(1);
        }
        return compileTaskArray;
    }

    @NotNull
    public abstract List<CompileTask> getAfterTaskList();

    public abstract void compile(VirtualFile @NotNull [] var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@Nullable CompileStatusNotification var1);

    public abstract void make(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@NotNull Project var1, Module @NotNull [] var2, @Nullable CompileStatusNotification var3);

    public abstract void make(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void makeWithModalProgress(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract boolean isUpToDate(@NotNull CompileScope var1);

    public abstract void rebuild(@Nullable CompileStatusNotification var1);

    public abstract void executeTask(@NotNull CompileTask var1, @NotNull CompileScope var2, String var3, @Nullable Runnable var4);

    @Deprecated
    public abstract void addCompilationStatusListener(@NotNull CompilationStatusListener var1);

    @Deprecated
    public abstract void addCompilationStatusListener(@NotNull CompilationStatusListener var1, @NotNull Disposable var2);

    @Deprecated
    public abstract void removeCompilationStatusListener(@NotNull CompilationStatusListener var1);

    public abstract boolean isExcludedFromCompilation(@NotNull VirtualFile var1);

    @NotNull
    public abstract CompileScope createFilesCompileScope(VirtualFile @NotNull [] var1);

    @NotNull
    public abstract CompileScope createModuleCompileScope(@NotNull Module var1, boolean var2);

    @NotNull
    public abstract CompileScope createModulesCompileScope(Module @NotNull [] var1, boolean var2);

    @NotNull
    public abstract CompileScope createModulesCompileScope(Module @NotNull [] var1, boolean var2, boolean var3);

    @NotNull
    public abstract CompileScope createModuleGroupCompileScope(@NotNull Project var1, Module @NotNull [] var2, boolean var3);

    @NotNull
    public abstract CompileScope createProjectCompileScope(@NotNull Project var1);

    public abstract void setValidationEnabled(ModuleType<?> var1, boolean var2);

    public abstract boolean isValidationEnabled(Module var1);

    public abstract Collection<ClassObject> compileJavaCode(List<String> var1, Collection<? extends File> var2, Collection<? extends File> var3, Collection<? extends File> var4, Collection<? extends File> var5, Collection<? extends File> var6, Collection<? extends File> var7, File var8) throws IOException, CompilationException;

    @Nullable
    public abstract File getJavacCompilerWorkingDir();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/CompilerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/CompilerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

