/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitLocalBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.merge.MergeChangeCollector;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import org.jetbrains.annotations.NotNull;

public abstract class GitUpdater {
    private static final Logger LOG = Logger.getInstance(GitUpdater.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final VirtualFile myRoot;
    @NotNull
    protected final GitRepository myRepository;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final UpdatedFiles myUpdatedFiles;
    @NotNull
    protected final AbstractVcsHelper myVcsHelper;
    @NotNull
    protected final GitRepositoryManager myRepositoryManager;
    protected final GitVcs myVcs;
    protected GitRevisionNumber myBefore;

    protected GitUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            GitUpdater.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitUpdater.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GitUpdater.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            GitUpdater.$$$reportNull$$$0(3);
        }
        if (updatedFiles == null) {
            GitUpdater.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myGit = git;
        this.myRoot = repository.getRoot();
        this.myRepository = repository;
        this.myProgressIndicator = progressIndicator;
        this.myUpdatedFiles = updatedFiles;
        this.myVcsHelper = AbstractVcsHelper.getInstance((Project)project);
        this.myVcs = GitVcs.getInstance(project);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    @NotNull
    public static GitUpdater getUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitBranchPair trackedBranches, @NotNull GitRepository repository, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles, @NotNull UpdateMethod updateMethod) {
        if (project == null) {
            GitUpdater.$$$reportNull$$$0(5);
        }
        if (git == null) {
            GitUpdater.$$$reportNull$$$0(6);
        }
        if (trackedBranches == null) {
            GitUpdater.$$$reportNull$$$0(7);
        }
        if (repository == null) {
            GitUpdater.$$$reportNull$$$0(8);
        }
        if (progressIndicator == null) {
            GitUpdater.$$$reportNull$$$0(9);
        }
        if (updatedFiles == null) {
            GitUpdater.$$$reportNull$$$0(10);
        }
        if (updateMethod == null) {
            GitUpdater.$$$reportNull$$$0(11);
        }
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(repository);
        }
        return updateMethod == UpdateMethod.REBASE ? new GitRebaseUpdater(project, git, repository, trackedBranches, progressIndicator, updatedFiles) : new GitMergeUpdater(project, git, repository, trackedBranches, progressIndicator, updatedFiles);
    }

    @NotNull
    public static UpdateMethod resolveUpdateMethod(@NotNull GitRepository repository) {
        block16: {
            Project project;
            block13: {
                if (repository == null) {
                    GitUpdater.$$$reportNull$$$0(12);
                }
                project = repository.getProject();
                GitLocalBranch branch = repository.getCurrentBranch();
                if (branch != null) {
                    String rebaseValue;
                    String branchName;
                    block15: {
                        block14: {
                            branchName = branch.getName();
                            rebaseValue = GitConfigUtil.getValue(project, repository.getRoot(), "branch." + branchName + ".rebase");
                            if (rebaseValue == null) break block13;
                            if (!GitUpdater.isRebaseValue(rebaseValue)) break block14;
                            UpdateMethod updateMethod = UpdateMethod.REBASE;
                            if (updateMethod == null) {
                                GitUpdater.$$$reportNull$$$0(13);
                            }
                            return updateMethod;
                        }
                        if (GitConfigUtil.getBooleanValue(rebaseValue) != Boolean.FALSE) break block15;
                        UpdateMethod updateMethod = UpdateMethod.MERGE;
                        if (updateMethod == null) {
                            GitUpdater.$$$reportNull$$$0(14);
                        }
                        return updateMethod;
                    }
                    try {
                        LOG.warn("Unknown value for branch." + branchName + ".rebase: " + rebaseValue);
                    }
                    catch (VcsException e) {
                        LOG.warn("Couldn't get git config branch." + branchName + ".rebase");
                    }
                }
            }
            if (GitVersionSpecialty.KNOWS_PULL_REBASE.existsIn(project)) {
                UpdateMethod updateMethod;
                try {
                    String pullRebaseValue = GitConfigUtil.getValue(project, repository.getRoot(), "pull.rebase");
                    if (pullRebaseValue == null || !GitUpdater.isRebaseValue(pullRebaseValue)) break block16;
                    updateMethod = UpdateMethod.REBASE;
                }
                catch (VcsException e) {
                    LOG.warn("Couldn't get git config pull.rebase");
                }
                if (updateMethod == null) {
                    GitUpdater.$$$reportNull$$$0(15);
                }
                return updateMethod;
            }
        }
        UpdateMethod updateMethod = UpdateMethod.MERGE;
        if (updateMethod == null) {
            GitUpdater.$$$reportNull$$$0(16);
        }
        return updateMethod;
    }

    private static boolean isRebaseValue(@NotNull String configValue) {
        if (configValue == null) {
            GitUpdater.$$$reportNull$$$0(17);
        }
        return GitConfigUtil.getBooleanValue(configValue) == Boolean.TRUE || configValue.equalsIgnoreCase("interactive") || configValue.equalsIgnoreCase("preserve");
    }

    @NotNull
    public GitUpdateResult update() throws VcsException {
        this.markStart(this.myRepository);
        GitUpdateResult result2 = this.doUpdate();
        this.myRepository.update();
        GitUpdateResult gitUpdateResult = result2;
        GitUpdateResult gitUpdateResult2 = gitUpdateResult;
        if (gitUpdateResult2 == null) {
            GitUpdater.$$$reportNull$$$0(18);
        }
        return gitUpdateResult2;
        finally {
            this.markEnd(this.myRepository);
        }
    }

    public abstract boolean isSaveNeeded();

    public boolean isUpdateNeeded(@NotNull GitBranchPair branchPair) throws VcsException {
        String remoteBranch;
        if (branchPair == null) {
            GitUpdater.$$$reportNull$$$0(19);
        }
        if (!this.hasRemoteChanges(remoteBranch = branchPair.getTarget().getName())) {
            LOG.info("isUpdateNeeded: No remote changes, update is not needed");
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract GitUpdateResult doUpdate();

    protected void markStart(GitRepository repository) throws VcsException {
        this.myBefore = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "HEAD");
    }

    protected void markEnd(GitRepository repository) throws VcsException {
        new MergeChangeCollector(this.myProject, repository, this.myBefore).collect(this.myUpdatedFiles);
    }

    protected boolean hasRemoteChanges(@NotNull String remoteBranch) throws VcsException {
        if (remoteBranch == null) {
            GitUpdater.$$$reportNull$$$0(20);
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, this.myRoot, GitCommand.REV_LIST);
        handler.setSilent(true);
        handler.addParameters("-1");
        handler.addParameters("HEAD.." + remoteBranch);
        String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]);
        return output != null && !output.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackedBranches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdater";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configValue";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPair";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdater";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveUpdateMethod";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUpdater";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveUpdateMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRebaseValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasRemoteChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

