/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.history.GitHistoryTraverser;
import git4idea.history.GitHistoryTraverserImpl;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.interactive.CantRebaseUsingLogException;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogEditorHandler;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.interactive.GitRebaseEntryGeneratedUsingLog;
import git4idea.rebase.interactive.dialog.GitInteractiveRebaseDialog;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getEntriesUsingLog", "", "Lgit4idea/rebase/interactive/GitRebaseEntryGeneratedUsingLog;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "interactivelyRebaseUsingLog", "", "startInteractiveRebase", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "intellij.vcs.git"})
public final class GitInteractiveRebaseUsingLogKt {
    private static final Logger LOG;

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    @NotNull
    public static final List<GitRebaseEntryGeneratedUsingLog> getEntriesUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @NotNull VcsLogData logData) throws CantRebaseUsingLogException {
        block8: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
                v0 = repository.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"repository.project");
                traverser = new GitHistoryTraverserImpl(v0, logData);
                var5_4 = false;
                details = new ArrayList<E>();
                try {
                    v1 = repository.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"repository.root");
                    GitHistoryTraverser.DefaultImpls.traverse$default(traverser, v1, null, null, (Function2)new Function2<GitHistoryTraverser.Traverse, GitHistoryTraverser.TraverseCommitInfo, Boolean>(details, traverser, commit){
                        final /* synthetic */ List $details;
                        final /* synthetic */ GitHistoryTraverser $traverser;
                        final /* synthetic */ VcsShortCommitDetails $commit;

                        /*
                         * WARNING - void declaration
                         */
                        public final boolean invoke(@NotNull GitHistoryTraverser.Traverse $this$traverse, @NotNull GitHistoryTraverser.TraverseCommitInfo $dstr$commitId$parents) {
                            void commitId;
                            Intrinsics.checkNotNullParameter((Object)$this$traverse, (String)"$receiver");
                            Intrinsics.checkNotNullParameter((Object)$dstr$commitId$parents, (String)"<name for destructuring parameter 0>");
                            int n = $dstr$commitId$parents.component1();
                            List<Integer> parents = $dstr$commitId$parents.component2();
                            if (parents.size() != 1) {
                                throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.MERGE);
                            }
                            $this$traverse.loadMetadataLater((int)commitId, (Function1<? super VcsCommitMetadata, Unit>)((Function1)new Function1<VcsCommitMetadata, Unit>(this){
                                final /* synthetic */ getEntriesUsingLog.1 this$0;

                                public final void invoke(@NotNull VcsCommitMetadata metadata) {
                                    Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                                    this.this$0.$details.add(metadata);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                            Hash hash = this.$traverser.toHash((int)commitId);
                            return Intrinsics.areEqual((Object)hash, (Object)this.$commit.getId()) ^ true;
                        }
                        {
                            this.$details = list2;
                            this.$traverser = gitHistoryTraverser;
                            this.$commit = vcsShortCommitDetails;
                            super(2);
                        }
                    }, 6, null);
                }
                catch (VcsException e) {
                    throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNRESOLVED_HASH);
                }
                if (Intrinsics.areEqual((Object)((VcsCommitMetadata)CollectionsKt.last((List)details)).getId(), (Object)commit.getId()) ^ true) {
                    throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNEXPECTED_HASH);
                }
                $this$any$iv = details;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block9;
                v2 = false;
                break block8;
            }
            for (T element$iv : $this$any$iv) {
                it = (VcsCommitMetadata)element$iv;
                $i$a$-any-GitInteractiveRebaseUsingLogKt$getEntriesUsingLog$2 = false;
                v3 = it.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.subject");
                if (StringsKt.startsWith$default((String)v3, (String)"fixup!", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v4 = it.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it.subject");
                if (StringsKt.startsWith$default((String)v4, (String)"squash!", (boolean)false, (int)2, null)) lbl-1000:
                // 2 sources

                {
                    v5 = true;
                } else {
                    v5 = false;
                }
                if (!v5) continue;
                v2 = true;
                break block8;
            }
            v2 = false;
        }
        if (v2) {
            throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.FIXUP_SQUASH);
        }
        $this$map$iv = details;
        $i$f$map = false;
        var7_9 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_16 = (VcsCommitMetadata)item$iv$iv;
            var14_18 = destination$iv$iv;
            $i$a$-map-GitInteractiveRebaseUsingLogKt$getEntriesUsingLog$3 = false;
            var15_19 = new GitRebaseEntryGeneratedUsingLog((VcsCommitMetadata)it);
            var14_18.add(var15_19);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    public static final void interactivelyRebaseUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit2, @NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        Project project2 = project;
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        VirtualFile root = virtualFile;
        new Task.Backgroundable(repository, commit2, logData, project2, root, project2, GitBundle.message("rebase.progress.indicator.preparing.title", new Object[0])){
            private List<GitRebaseEntryGeneratedUsingLog> generatedEntries;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $root;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    this.generatedEntries = GitInteractiveRebaseUsingLogKt.getEntriesUsingLog(this.$repository, this.$commit, this.$logData);
                }
                catch (CantRebaseUsingLogException e) {
                    GitInteractiveRebaseUsingLogKt.access$getLOG$p().warn("Couldn't use log for rebasing: " + e.getMessage());
                }
            }

            public void onSuccess() {
                List<GitRebaseEntryGeneratedUsingLog> list2 = this.generatedEntries;
                if (list2 != null) {
                    List<GitRebaseEntryGeneratedUsingLog> list3 = list2;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<GitRebaseEntryGeneratedUsingLog> entries = list3;
                    boolean bl3 = false;
                    GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog> dialog2 = new GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog>(this.$project, this.$root, entries);
                    dialog2.show();
                    if (dialog2.isOK()) {
                        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(this.$repository, this.$commit, new GitInteractiveRebaseUsingLogEditorHandler(this.$repository, entries, dialog2.getModel()));
                    }
                } else {
                    GitInteractiveRebaseUsingLogKt.startInteractiveRebase$default(this.$repository, this.$commit, null, 4, null);
                }
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$logData = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$root = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    public static final void startInteractiveRebase(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit2, @Nullable GitRebaseEditorHandler editorHandler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit2, (String)"commit");
        new Task.Backgroundable(repository, commit2, editorHandler, repository.getProject(), GitBundle.message("rebase.progress.indicator.title", new Object[0])){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ GitRebaseEditorHandler $editorHandler;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitVcs gitVcs = this.$repository.getVcs();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"repository.vcs");
                GitVersion gitVersion = gitVcs.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"repository.vcs.version");
                List list2 = this.$commit.getParents();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"commit.parents");
                String string = ((Hash)CollectionsKt.first((List)list2)).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commit.parents.first().asString()");
                GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, string, this.$editorHandler, false, null, 16, null);
                GitRebaseUtils.rebase(this.$repository.getProject(), CollectionsKt.listOf((Object)this.$repository), params, indicator);
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$editorHandler = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    public static /* synthetic */ void startInteractiveRebase$default(GitRepository gitRepository, VcsShortCommitDetails vcsShortCommitDetails, GitRebaseEditorHandler gitRebaseEditorHandler, int n, Object object) {
        if ((n & 4) != 0) {
            gitRebaseEditorHandler = null;
        }
        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, gitRebaseEditorHandler);
    }

    static {
        Logger logger = Logger.getInstance((String)"Git.Interactive.Rebase.Using.Log");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"Git.\u2026active.Rebase.Using.Log\")");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

