/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import git4idea.commands.GitHandler;
import git4idea.config.GitExecutable;
import git4idea.rebase.GitRebaseEditorHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.editor.GitRebaseEditorApp;
import org.jetbrains.git4idea.editor.GitRebaseEditorXmlRpcHandler;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public class GitRebaseEditorService
implements Disposable {
    private final Object myScriptLock = new Object();
    private final Map<UUID, Pair<GitRebaseEditorHandler, GitExecutable>> myHandlers = new HashMap<UUID, Pair<GitRebaseEditorHandler, GitExecutable>>();
    private final Object myHandlersLock = new Object();
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ApplicationManager.getApplication().getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        GitRebaseEditorService gitRebaseEditorService = service;
        if (gitRebaseEditorService == null) {
            GitRebaseEditorService.$$$reportNull$$$0(0);
        }
        return gitRebaseEditorService;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME)) {
            xmlRpcServer.addHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME, (Object)new InternalHandlerRebase());
        }
    }

    public void dispose() {
        XmlRpcServer xmlRpcServer = (XmlRpcServer)ApplicationManager.getApplication().getServiceIfCreated(XmlRpcServer.class);
        if (xmlRpcServer != null) {
            xmlRpcServer.removeHandler(GitRebaseEditorXmlRpcHandler.HANDLER_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getEditorCommand(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitRebaseEditorService.$$$reportNull$$$0(1);
        }
        Object object = this.myScriptLock;
        // MONITORENTER : object
        ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorApp.class);
        generator.addInternal(Integer.toString(BuiltInServerManager.getInstance().waitForStart().getPort()));
        String string = generator.commandLine(executable);
        // MONITOREXIT : object
        if (string != null) return string;
        GitRebaseEditorService.$$$reportNull$$$0(2);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UUID registerHandler(@NotNull GitHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitRebaseEditorService.$$$reportNull$$$0(3);
        }
        if (editorHandler == null) {
            GitRebaseEditorService.$$$reportNull$$$0(4);
        }
        this.addInternalHandler();
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        UUID key = UUID.randomUUID();
        this.myHandlers.put(key, (Pair<GitRebaseEditorHandler, GitExecutable>)Pair.create((Object)editorHandler, (Object)handler.getExecutable()));
        UUID uUID = key;
        // MONITOREXIT : object
        if (uUID != null) return uUID;
        GitRebaseEditorService.$$$reportNull$$$0(5);
        return uUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            GitRebaseEditorService.$$$reportNull$$$0(6);
        }
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Pair<GitRebaseEditorHandler, GitExecutable> getHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            GitRebaseEditorService.$$$reportNull$$$0(7);
        }
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        Pair<GitRebaseEditorHandler, GitExecutable> pair2 = this.myHandlers.get(handlerNo);
        if (pair2 == null) {
            throw new IllegalStateException("The handler " + handlerNo + " is not registered");
        }
        Pair<GitRebaseEditorHandler, GitExecutable> pair = pair2;
        // MONITOREXIT : object
        if (pair != null) return pair;
        GitRebaseEditorService.$$$reportNull$$$0(8);
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseEditorService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerNo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseEditorService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "registerHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditorCommand";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class InternalHandlerRebase
    implements GitRebaseEditorXmlRpcHandler {
        public int editCommits(@NotNull String handlerNo, @NotNull String path, @NotNull String workingDir) {
            if (handlerNo == null) {
                InternalHandlerRebase.$$$reportNull$$$0(0);
            }
            if (path == null) {
                InternalHandlerRebase.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                InternalHandlerRebase.$$$reportNull$$$0(2);
            }
            Pair<GitRebaseEditorHandler, GitExecutable> pair = GitRebaseEditorService.this.getHandler(UUID.fromString(handlerNo));
            GitExecutable executable = (GitExecutable)pair.second;
            GitRebaseEditorHandler editorHandler = (GitRebaseEditorHandler)pair.first;
            File file = executable.convertFilePathBack(path, new File(workingDir));
            return editorHandler.editCommits(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handlerNo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseEditorService$InternalHandlerRebase";
            objectArray[2] = "editCommits";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

