/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitInit
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitInit.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.message("init.destination.directory.title", new Object[0]));
        fcd.setDescription(GitBundle.message("init.destination.directory.description", new Object[0]));
        fcd.setHideIgnored(false);
        VirtualFile baseDir = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (baseDir == null || !baseDir.isDirectory()) {
            baseDir = project.getBaseDir();
        }
        GitInit.doInit(project, fcd, baseDir);
    }

    private static void doInit(final @NotNull Project project, @NotNull FileChooserDescriptor fcd, VirtualFile baseDir) {
        if (project == null) {
            GitInit.$$$reportNull$$$0(1);
        }
        if (fcd == null) {
            GitInit.$$$reportNull$$$0(2);
        }
        FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)project, (VirtualFile)baseDir, root -> {
            if (GitUtil.isUnderGit(root) && Messages.showYesNoDialog((Project)project, (String)XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("init.warning.already.under.git", StringUtil.escapeXmlEntities((String)root.getPresentableUrl()))), (String)GitBundle.message("init.warning.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
            new Task.Backgroundable(project, GitBundle.message("common.refreshing", new Object[0]), (VirtualFile)root){
                final /* synthetic */ VirtualFile val$root;
                {
                    this.val$root = virtualFile;
                    super(arg0, arg1);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    GitCommandResult result2;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!(result2 = Git.getInstance().init(project, this.val$root, new GitLineHandlerListener[0])).success()) {
                        VcsNotifier.getInstance((Project)project).notifyError("git.init.failed", GitBundle.message("action.Git.Init.error", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                        return;
                    }
                    if (project.isDefault()) {
                        return;
                    }
                    GitInit.refreshAndConfigureVcsMappings(project, this.val$root, this.val$root.getPath());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitInit$1", "run"));
                }
            }.queue();
        });
    }

    public static void refreshAndConfigureVcsMappings(@NotNull Project project, @NotNull VirtualFile root, @NotNull String path) {
        if (project == null) {
            GitInit.$$$reportNull$$$0(3);
        }
        if (root == null) {
            GitInit.$$$reportNull$$$0(4);
        }
        if (path == null) {
            GitInit.$$$reportNull$$$0(5);
        }
        GitUtil.refreshVfsInRoot(root);
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"Git"));
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fcd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "git4idea/actions/GitInit";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doInit";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshAndConfigureVcsMappings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

