/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.GradleDslBuildScriptUtil;
import com.android.tools.idea.gradle.dsl.GradleUtil;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.include.IncludeDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModelImpl
extends GradleFileModelImpl
implements GradleSettingsModel {
    private static final String INCLUDE_BUILD = "includeBuild";

    @Deprecated
    @Nullable
    public static GradleSettingsModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleSettingsFile(GradleUtil.getBaseDirPath(project))) != null ? GradleSettingsModelImpl.parseBuildFile(file, project, "settings") : null;
    }

    @NotNull
    public static GradleSettingsModel get(@NotNull VirtualFile settingsFile, @NotNull Project hostProject) {
        if (settingsFile == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(1);
        }
        if (hostProject == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(2);
        }
        return GradleSettingsModelImpl.parseBuildFile(settingsFile, hostProject, "settings");
    }

    @NotNull
    private static GradleSettingsModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(4);
        }
        if (moduleName == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(5);
        }
        GradleSettingsFile settingsFile = new GradleSettingsFile(file, project, moduleName, BuildModelContext.create(project));
        settingsFile.parse();
        return new GradleSettingsModelImpl(settingsFile);
    }

    public GradleSettingsModelImpl(@NotNull GradleSettingsFile parsedModel) {
        if (parsedModel == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(6);
        }
        super(parsedModel);
    }

    @NotNull
    public List<String> modulePaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(":");
        IncludeDslElement includePaths = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE);
        if (includePaths == null) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                GradleSettingsModelImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        for (GradleDslSimpleExpression includePath : includePaths.getModules()) {
            String value = includePath.getValue(String.class);
            if (value == null) continue;
            result.add(GradleSettingsModelImpl.standardiseModulePath(value));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void addModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(9);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        IncludeDslElement includeDslElement = this.myGradleDslFile.ensurePropertyElement(IncludeDslElement.INCLUDE);
        GradleDslLiteral literal = new GradleDslLiteral(includeDslElement, GradleNameElement.create(IncludeDslElement.INCLUDE.name));
        literal.setValue(modulePath);
        includeDslElement.setNewElement(literal);
    }

    public void removeModulePath(@NotNull String modulePath) {
        IncludeDslElement includeDslElement;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(10);
        }
        if ((includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE)) != null) {
            if (!modulePath.startsWith(":")) {
                includeDslElement.removeModule(":" + modulePath);
            }
            includeDslElement.removeModule(modulePath);
        }
    }

    public void replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        IncludeDslElement includeDslElement;
        if (oldModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(11);
        }
        if (newModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(12);
        }
        if ((includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE)) != null) {
            if (!((String)newModulePath).startsWith(":")) {
                newModulePath = ":" + (String)newModulePath;
            }
            if (!oldModulePath.startsWith(":")) {
                includeDslElement.replaceModulePath(":" + oldModulePath, newModulePath);
            }
            includeDslElement.replaceModulePath(oldModulePath, newModulePath);
        }
    }

    @Nullable
    public File moduleDirectory(String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        return this.moduleDirectoryNoCheck(modulePath);
    }

    public void setModuleDirectory(@NotNull String modulePath, @NotNull File moduleDir) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(13);
        }
        if (moduleDir == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(14);
        }
        String projectKey = "project('" + modulePath + "')";
        String projectDirPropertyName = projectKey + ".projectDir";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            projectProperties.removeProperty("projectDir");
        }
        this.myGradleDslFile.removeProperty(projectDirPropertyName);
        GradleNameElement gradleNameElement = GradleNameElement.create(projectDirPropertyName);
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)this.myGradleDslFile, gradleNameElement, "file");
        methodCall.setUseAssignment(true);
        this.myGradleDslFile.setNewElement(methodCall);
        String dirPath = moduleDir.getAbsolutePath();
        File rootDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (VfsUtilCore.isAncestor((File)rootDir, (File)moduleDir, (boolean)false)) {
            GradleDslLiteral rootDirArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            rootDirArg.setValue(new ReferenceTo("rootDir"));
            methodCall.addNewArgument(rootDirArg);
            methodCall.setMethodName("File");
            methodCall.setIsConstructor(true);
            dirPath = rootDir.toURI().relativize(moduleDir.toURI()).getPath();
        }
        if (dirPath != null && !dirPath.isEmpty()) {
            GradleDslLiteral extraArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            extraArg.setValue(dirPath);
            methodCall.addNewArgument(extraArg);
        }
    }

    @Nullable
    private File moduleDirectoryNoCheck(String modulePath) {
        File parentDir;
        File projectDir;
        File rootDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (modulePath.equals(":")) {
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = GradleSettingsModelImpl.parentModuleNoCheck(modulePath);
            if (parentModule == null) {
                return null;
            }
            parentDir = this.moduleDirectoryNoCheck(parentModule);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        return new File(parentDir, moduleName);
    }

    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        if (moduleDir == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(15);
        }
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectoryNoCheck(modulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(16);
        }
        if ((buildFilePath = this.buildFile(modulePath)) == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)false);
        if (buildFile == null) {
            return null;
        }
        GradleBuildFile dslFile = this.myGradleDslFile.getContext().getOrCreateBuildFile(buildFile, modulePath.substring(modulePath.lastIndexOf(58) + 1), false);
        return new GradleBuildModelImpl(dslFile);
    }

    @Nullable
    public String parentModule(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(17);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        List<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        String currentPath = modulePath;
        do {
            if (!allModulePaths.contains(currentPath = GradleSettingsModelImpl.parentModuleNoCheck(currentPath))) continue;
            return currentPath;
        } while (currentPath != null && !currentPath.equals(":"));
        return null;
    }

    @Nullable
    private static String parentModuleNoCheck(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(18);
        }
        if ((modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath)).equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        return lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
    }

    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(19);
        }
        if ((parentModule = this.parentModule(modulePath)) == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(20);
        }
        if ((moduleDirectory = this.moduleDirectory(modulePath)) == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = projectProperties.getLiteral("buildFileName", String.class);
        }
        if (buildFileName == null) {
            return GradleDslBuildScriptUtil.findGradleBuildFile(moduleDirectory);
        }
        return new File(moduleDirectory, buildFileName);
    }

    @NotNull
    public List<VirtualFile> includedBuilds() {
        List<GradleDslElement> properties = this.myGradleDslFile.getPropertyElementsByName(INCLUDE_BUILD);
        List<VirtualFile> list = properties.stream().map(element -> {
            String value = GradleSettingsModelImpl.extractValueFromElement(element);
            if (value == null) {
                return null;
            }
            return this.attemptToFindIncludedBuildRoot(value);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(22);
        }
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    @Nullable
    private static String extractValueFromElement(@Nullable GradleDslElement element) {
        if (!(element instanceof GradleDslSimpleExpression)) {
            return null;
        }
        return ((GradleDslSimpleExpression)element).getValue(String.class);
    }

    @Nullable
    private VirtualFile attemptToFindIncludedBuildRoot(@NotNull String fileName) {
        File realFile;
        VirtualFile file;
        if (fileName == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(23);
        }
        if ((file = (realFile = new File(fileName)).isAbsolute() ? LocalFileSystem.getInstance().findFileByIoFile(realFile) : this.myGradleDslFile.getFile().getParent().findFileByRelativePath(fileName)) != null && file.isDirectory()) {
            File compositeRoot = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(compositeRoot);
            if (buildFile != null) {
                return file;
            }
            VirtualFile settingsFile = GradleUtil.getGradleSettingsFile(compositeRoot);
            if (settingsFile != null) {
                return file;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModulePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModulePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "modulePaths";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "includedBuilds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeModulePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceModulePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setModuleDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDirectory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "moduleModel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parentModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parentModuleNoCheck";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleModel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "buildFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "standardiseModulePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "attemptToFindIncludedBuildRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

