/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.AbstractInheritableJavaEntity;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultJavaExecutable
extends AbstractInheritableJavaEntity
implements JavaExecutable {
    private List<JavaParameter> parameters = Collections.emptyList();
    private List<JavaClass> exceptions = Collections.emptyList();
    private boolean varArgs;
    private String sourceCode;

    @Override
    public List<JavaParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public JavaParameter getParameterByName(String name) {
        for (JavaParameter parameter : this.getParameters()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public List<JavaClass> getExceptions() {
        return new LinkedList<JavaClass>(this.exceptions);
    }

    @Override
    public List<JavaType> getExceptionTypes() {
        return new LinkedList<JavaType>(this.exceptions);
    }

    @Override
    public boolean isVarArgs() {
        return this.varArgs;
    }

    public void setParameters(List<JavaParameter> javaParameters) {
        this.parameters = javaParameters;
        this.varArgs = javaParameters.get(javaParameters.size() - 1).isVarArgs();
    }

    public void setExceptions(List<JavaClass> exceptions) {
        this.exceptions = exceptions;
    }

    protected boolean signatureMatches(List<JavaType> parameterTypes, boolean varArgs) {
        List<Object> parameterTypeList = parameterTypes == null ? Collections.emptyList() : parameterTypes;
        if (parameterTypeList.size() != this.getParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getParameters().size(); ++i) {
            if (this.getParameters().get(i).getType().equals(parameterTypes.get(i))) continue;
            return false;
        }
        return this.varArgs == varArgs;
    }

    @Override
    public boolean isPublic() {
        return super.isPublic() || this.getDeclaringClass() != null && this.getDeclaringClass().isInterface();
    }

    @Override
    public List<DocletTag> getTagsByName(String name, boolean inherited) {
        JavaClass cls = this.getDeclaringClass();
        LinkedList<JavaType> types = new LinkedList<JavaType>();
        for (JavaParameter parameter : this.getParameters()) {
            types.add(parameter.getType());
        }
        List<JavaMethod> methods = cls.getMethodsBySignature(this.getName(), types, true);
        LinkedList<DocletTag> result = new LinkedList<DocletTag>();
        for (JavaMethod method : methods) {
            List<DocletTag> tags = method.getTagsByName(name);
            for (DocletTag tag : tags) {
                if (result.contains(tag)) continue;
                result.add(tag);
            }
        }
        return result;
    }

    @Override
    public List<JavaType> getParameterTypes() {
        return this.getParameterTypes(false);
    }

    @Override
    public List<JavaType> getParameterTypes(boolean resolve) {
        LinkedList<JavaType> result = new LinkedList<JavaType>();
        for (JavaParameter parameter : this.getParameters()) {
            result.add(parameter.getType());
        }
        return result;
    }

    @Override
    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    @Override
    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    protected JavaType getReturns() {
        return null;
    }

    protected String getSignature(boolean withModifiers, boolean isDeclaration) {
        StringBuilder result = new StringBuilder();
        if (withModifiers) {
            for (String modifier : this.getModifiers()) {
                if (!modifier.startsWith("p")) continue;
                result.append(modifier).append(' ');
            }
            for (String modifier : this.getModifiers()) {
                if (modifier.startsWith("p")) continue;
                result.append(modifier).append(' ');
            }
        }
        if (isDeclaration && this.getReturns() != null) {
            result.append(this.getReturns().getGenericCanonicalName());
            result.append(' ');
        }
        result.append(this.getName());
        result.append('(');
        ListIterator<JavaParameter> iter = this.getParameters().listIterator();
        while (iter.hasNext()) {
            JavaParameter parameter = iter.next();
            if (isDeclaration) {
                result.append(parameter.getType().getGenericCanonicalName());
                if (parameter.isVarArgs()) {
                    result.append("...");
                }
                result.append(' ');
            }
            result.append(parameter.getName());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append(')');
        if (isDeclaration && !this.getExceptions().isEmpty()) {
            result.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result.append(excIter.next().getGenericCanonicalName());
                if (!excIter.hasNext()) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }
}

