/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.codeInsight.navigation.PsiElementNavigationTarget;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH$J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010 \u001a\u00020!J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectSymbol;", "Lcom/intellij/model/presentation/PresentableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/find/usages/api/SearchTarget;", "rootProjectPath", "", "(Ljava/lang/String;)V", "presentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "getPresentation", "()Lcom/intellij/navigation/TargetPopupPresentation;", "projectName", "getProjectName", "()Ljava/lang/String;", "qualifiedName", "getQualifiedName", "getRootProjectPath", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "rootProject", "findBuildFile", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "getNavigationTargets", "", "Lcom/intellij/navigation/NavigationTarget;", "hashCode", "", "intellij.gradle.java"})
@ApiStatus.Internal
public abstract class GradleProjectSymbol
implements PresentableSymbol,
NavigatableSymbol,
SearchTarget {
    @NotNull
    private final String rootProjectPath;

    @NotNull
    public Pointer<? extends GradleProjectSymbol> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"Pointer.hardPointer(this)");
        return pointer;
    }

    @NotNull
    public abstract String getProjectName();

    @NotNull
    public abstract String getQualifiedName();

    @NotNull
    public final Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement psiFile = this.findBuildFile(project);
        if (psiFile != null) {
            return CollectionsKt.listOf((Object)new PsiElementNavigationTarget(psiFile));
        }
        return CollectionsKt.emptyList();
    }

    private final PsiElement findBuildFile(Project project) {
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)project).getRootExternalProject(this.rootProjectPath);
        if (externalProject == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalProject, (String)"ExternalProjectDataCache\u2026ojectPath) ?: return null");
        ExternalProject rootProject = externalProject;
        Object object = this.externalProject(rootProject);
        if (object == null || (object = object.getBuildFile()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"externalProject(rootProj\u2026.buildFile ?: return null");
        Object buildFile = object;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile((File)buildFile);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026buildFile) ?: return null");
        VirtualFile virtualFile2 = virtualFile;
        return (PsiElement)PsiManager.getInstance((Project)project).findFile(virtualFile2);
    }

    @Nullable
    protected abstract ExternalProject externalProject(@NotNull ExternalProject var1);

    @NotNull
    public UsageHandler<?> getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.getProjectName());
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"UsageHandler.createEmptyUsageHandler(projectName)");
        return usageHandler;
    }

    @NotNull
    public TargetPopupPresentation getPresentation() {
        SymbolPresentation symbolPresentation = this.getSymbolPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)symbolPresentation, (String)"symbolPresentation");
        SymbolPresentation presentation2 = symbolPresentation;
        return new TargetPopupPresentation(presentation2){
            final /* synthetic */ SymbolPresentation $presentation;

            @Nullable
            public Icon getIcon() {
                return this.$presentation.getIcon();
            }

            @NotNull
            public String getPresentableText() {
                String string = this.$presentation.getLongDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"presentation.longDescription");
                return string;
            }
            {
                this.$presentation = $captured_local_variable$0;
            }
        };
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol");
        }
        GradleProjectSymbol cfr_ignored_0 = (GradleProjectSymbol)object2;
        return !(Intrinsics.areEqual((Object)this.rootProjectPath, (Object)((GradleProjectSymbol)other).rootProjectPath) ^ true);
    }

    public int hashCode() {
        return this.rootProjectPath.hashCode();
    }

    @NotNull
    protected final String getRootProjectPath() {
        return this.rootProjectPath;
    }

    public GradleProjectSymbol(@NotNull String rootProjectPath) {
        Intrinsics.checkNotNullParameter((Object)rootProjectPath, (String)"rootProjectPath");
        this.rootProjectPath = rootProjectPath;
        CharSequence charSequence = this.rootProjectPath;
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }
}

