/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.ImageValue;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.mvstore.MVMap;
import org.jetbrains.mvstore.MVStore;
import org.jetbrains.mvstore.type.DataType;
import org.jetbrains.mvstore.type.KeyableDataType;
import org.jetbrains.mvstore.type.LongDataType;

@ApiStatus.Internal
public final class SvgPrebuiltCacheManager {
    private final MVStore store;
    private final Map<Float, MVMap<Long, ImageValue>> scaleToMap;
    private final MVMap.Builder<Long, ImageValue> mapBuilder;

    public SvgPrebuiltCacheManager(@NotNull Path dbFile) throws IOException {
        if (dbFile == null) {
            SvgPrebuiltCacheManager.$$$reportNull$$$0(0);
        }
        this.scaleToMap = new ConcurrentHashMap<Float, MVMap<Long, ImageValue>>(2, 0.75f, 2);
        MVStore.Builder storeBuilder = new MVStore.Builder().readOnly().backgroundExceptionHandler((e, store) -> SvgCacheManager.getLogger().error("Icon Cache Error (db=" + store.getFileStore() + ")", e)).autoCommitDelay(60000).compressHigh();
        this.store = storeBuilder.open(dbFile);
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.keyType((KeyableDataType)LongDataType.INSTANCE);
        mapBuilder.valueType((DataType)new ImageValue.ImageValueSerializer());
        this.mapBuilder = mapBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Image loadFromCache(long key, float scale, boolean isDark, @NotNull ImageLoader.Dimension2DDouble dimension2DDouble) {
        if (dimension2DDouble == null) {
            SvgPrebuiltCacheManager.$$$reportNull$$$0(1);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        try {
            void docSize;
            ImageValue data = (ImageValue)SvgCacheManager.getMap(scale, isDark, this.scaleToMap, this.store, this.mapBuilder).get((Object)key);
            if (data == null) {
                return null;
            }
            Image image = SvgCacheManager.readImage(data, (ImageLoader.Dimension2DDouble)docSize);
            IconLoadMeasurer.svgPreBuiltLoad.end(start);
            return image;
        }
        catch (Exception e) {
            SvgCacheManager.getLogger().error((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docSize";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/svg/SvgPrebuiltCacheManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFromCache";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

