/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class CachingPainter {
    private static final Map<Object, CachedPainting> ourCache = new WeakHashMap<Object, CachedPainting>();

    public static void paint(@NotNull Graphics2D g, float x, float y, float width, float height, @NotNull Consumer<Graphics2D> painter, @NotNull Object key, Object ... parameters) {
        int validationResult;
        GraphicsConfiguration config;
        float scale;
        if (g == null) {
            CachingPainter.$$$reportNull$$$0(0);
        }
        if (painter == null) {
            CachingPainter.$$$reportNull$$$0(1);
        }
        if (key == null) {
            CachingPainter.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            CachingPainter.$$$reportNull$$$0(3);
        }
        if ((float)((int)(scale = JBUIScale.sysScale(config = g.getDeviceConfiguration()))) != scale) {
            CachingPainter.paintAndDispose((Graphics2D)g.create(), _g -> {
                _g.setComposite(AlphaComposite.SrcOver);
                _g.translate(x, y);
                painter.accept((Graphics2D)_g);
            });
            return;
        }
        int xInt = (int)Math.floor(x);
        int yInt = (int)Math.floor(y);
        int widthInt = (int)Math.ceil(x + width) - xInt;
        int heightInt = (int)Math.ceil(y + height) - yInt;
        CachedPainting painting = ourCache.get(key);
        if (painting != null && !painting.matches(config, width, height, parameters)) {
            painting = null;
        }
        int n = validationResult = painting == null ? 2 : painting.image.validate(config);
        if (validationResult == 2) {
            painting = new CachedPainting(config, width, height, widthInt, heightInt, parameters);
            ourCache.put(key, painting);
        }
        if (validationResult != 0) {
            JBHiDPIScaledImage bi = new JBHiDPIScaledImage(config, (double)widthInt, (double)heightInt, 2, PaintUtil.RoundingMode.ROUND);
            CachingPainter.paintAndDispose(((BufferedImage)bi).createGraphics(), _g -> {
                _g.setComposite(AlphaComposite.Src);
                _g.translate(x - (float)xInt, y - (float)yInt);
                painter.accept((Graphics2D)_g);
            });
            CachingPainter.paintAndDispose(painting.image.createGraphics(), _g -> {
                _g.setComposite(AlphaComposite.Src);
                StartupUiUtil.drawImage((Graphics)_g, (Image)bi, 0, 0, null);
            });
        }
        Composite savedComposite = g.getComposite();
        g.setComposite(AlphaComposite.SrcOver);
        g.drawImage(painting.image, xInt, yInt, null);
        g.setComposite(savedComposite);
    }

    private static void paintAndDispose(Graphics2D g, Consumer<Graphics2D> painter) {
        try {
            painter.accept(g);
        }
        finally {
            g.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "g";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "painter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/CachingPainter";
        objectArray[2] = "paint";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CachedPainting {
        private final float width;
        private final float height;
        private final Object[] parameters;
        private final VolatileImage image;
        private final AffineTransform deviceTransform;

        private CachedPainting(GraphicsConfiguration config, float width, float height, int widthInt, int heightInt, Object[] parameters) {
            this.width = width;
            this.height = height;
            this.parameters = parameters;
            this.image = config.createCompatibleVolatileImage(widthInt, heightInt, 3);
            this.deviceTransform = config.getDefaultTransform();
        }

        private boolean matches(GraphicsConfiguration config, float width, float height, Object[] parameters) {
            return this.width == width && this.height == height && Objects.equals(this.deviceTransform, config.getDefaultTransform()) && Arrays.equals(this.parameters, parameters);
        }
    }
}

