/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.resolvedCallUtil;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\n\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\n\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u0006\u0012\u0002\b\u00030\n\u001a\u000e\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n\u001a\u001c\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a8\u0006\u0018"}, d2={"getArgumentByParameterIndex", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "index", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getExplicitReceiverValue", "getImplicitReceiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "getImplicitReceivers", "", "hasBothReceivers", "", "hasSafeNullableReceiver", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasThisOrNoDispatchReceiver", "makeNullableTypeIfSafeReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "frontend"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $this$hasThisOrNoDispatchReceiver, @NotNull BindingContext context2) {
        KtExpression expression2;
        Intrinsics.checkNotNullParameter($this$hasThisOrNoDispatchReceiver, (String)"$this$hasThisOrNoDispatchReceiver");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ReceiverValue dispatchReceiverValue2 = $this$hasThisOrNoDispatchReceiver.getDispatchReceiver();
        Object obj = $this$hasThisOrNoDispatchReceiver.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"resultingDescriptor");
        if (obj.getDispatchReceiverParameter() == null || dispatchReceiverValue2 == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        ReceiverValue receiverValue = dispatchReceiverValue2;
        if (receiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue2).getDeclarationDescriptor();
        } else if (receiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue2).getClassQualifier().getDescriptor();
        } else if (receiverValue instanceof ExpressionReceiver && (expression2 = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue2).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
        }
        Object obj2 = $this$hasThisOrNoDispatchReceiver.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj2, (String)"resultingDescriptor");
        return Intrinsics.areEqual((Object)dispatchReceiverDescriptor, (Object)DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(obj2));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $this$getExplicitReceiverValue) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter($this$getExplicitReceiverValue, (String)"$this$getExplicitReceiverValue");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$0[$this$getExplicitReceiverValue.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue2 = $this$getExplicitReceiverValue.getDispatchReceiver();
                receiverValue = receiverValue2;
                Intrinsics.checkNotNull((Object)receiverValue2);
                break;
            }
            case 2: 
            case 3: {
                ReceiverValue receiverValue3 = $this$getExplicitReceiverValue.getExtensionReceiver();
                receiverValue = receiverValue3;
                Intrinsics.checkNotNull((Object)receiverValue3);
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $this$getImplicitReceiverValue) {
        Intrinsics.checkNotNullParameter($this$getImplicitReceiverValue, (String)"$this$getImplicitReceiverValue");
        Object object = CollectionsKt.firstOrNull((Iterable)ResolvedCallUtilKt.getImplicitReceivers($this$getImplicitReceiverValue));
        if (!(object instanceof ImplicitReceiver)) {
            object = null;
        }
        return (ImplicitReceiver)object;
    }

    @NotNull
    public static final Collection<ReceiverValue> getImplicitReceivers(@NotNull ResolvedCall<?> $this$getImplicitReceivers) {
        List list2;
        Intrinsics.checkNotNullParameter($this$getImplicitReceivers, (String)"$this$getImplicitReceivers");
        switch (ResolvedCallUtilKt$WhenMappings.$EnumSwitchMapping$1[$this$getImplicitReceivers.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                list2 = CollectionsKt.listOfNotNull((Object[])new ReceiverValue[]{$this$getImplicitReceivers.getExtensionReceiver(), $this$getImplicitReceivers.getDispatchReceiver()});
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOfNotNull((Object)$this$getImplicitReceivers.getExtensionReceiver());
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOfNotNull((Object)$this$getImplicitReceivers.getDispatchReceiver());
                break;
            }
            case 4: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private static final boolean hasSafeNullableReceiver(ResolvedCall<?> $this$hasSafeNullableReceiver, CallResolutionContext<?> context2) {
        Object object;
        block5: {
            block4: {
                Call call2 = $this$hasSafeNullableReceiver.getCall();
                Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"call");
                if (!CallUtilKt.isSafeCall(call2)) {
                    return false;
                }
                object = ResolvedCallUtilKt.getExplicitReceiverValue($this$hasSafeNullableReceiver);
                if (object == null) break block4;
                ReceiverValue receiverValue = object;
                boolean bl = false;
                boolean bl2 = false;
                ReceiverValue it = receiverValue;
                boolean bl3 = false;
                object = context2.dataFlowValueFactory.createDataFlowValue(it, (ResolutionContext)context2);
                if (object != null) break block5;
            }
            return false;
        }
        Object receiverValue = object;
        return context2.dataFlowInfo.getStableNullability((DataFlowValue)receiverValue).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $this$makeNullableTypeIfSafeReceiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$makeNullableTypeIfSafeReceiver, (String)"$this$makeNullableTypeIfSafeReceiver");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType kotlinType3 = kotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            KotlinType it = kotlinType3;
            boolean bl3 = false;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($this$makeNullableTypeIfSafeReceiver, context2));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $this$hasBothReceivers) {
        Intrinsics.checkNotNullParameter($this$hasBothReceivers, (String)"$this$hasBothReceivers");
        return $this$hasBothReceivers.getDispatchReceiver() != null && $this$hasBothReceivers.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $this$getDispatchReceiverWithSmartCast) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiverWithSmartCast, (String)"$this$getDispatchReceiverWithSmartCast");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($this$getDispatchReceiverWithSmartCast.getDispatchReceiver(), $this$getDispatchReceiverWithSmartCast.getSmartCastDispatchReceiverType());
    }

    @NotNull
    public static final List<ValueArgument> getArgumentByParameterIndex(@NotNull KtCallElement $this$getArgumentByParameterIndex, int index2, @NotNull BindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentByParameterIndex, (String)"$this$getArgumentByParameterIndex");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getArgumentByParameterIndex, context2);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> list2 = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"resolvedCall.resultingDescriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.getOrNull(list2, (int)index2);
        if (valueParameterDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ValueParameterDescriptor parameterToProcess = valueParameterDescriptor;
        Object object = resolvedCall3.getValueArguments().get(parameterToProcess);
        if (object == null || (object = object.getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }
}

