/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceCandidate;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceOverloadConflictResolver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferencesCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceCandidatesAmbiguity;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarning;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarningOnArgument;
import org.jetbrains.kotlin.resolve.calls.model.EagerCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NoneCallableReferenceCandidates;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.TowerResolver;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016JX\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010 \u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u000e0!\u0012\u0004\u0012\u00020\u000e0!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "", "towerResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;", "callableReferenceOverloadConflictResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "buildResolvedKtArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "lhsResult", "Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;", "processCallableReferenceArgument", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "resolvedAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallableReferenceAtom;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "runRHSResolution", "", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceCandidate;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "callableReference", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "compatibilityChecker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "resolution"})
public final class CallableReferenceResolver {
    private final TowerResolver towerResolver;
    private final CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver;
    private final KotlinCallComponents callComponents;

    /*
     * WARNING - void declaration
     */
    public final void processCallableReferenceArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ResolvedCallableReferenceAtom resolvedAtom, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter((Object)csBuilder, (String)"csBuilder");
        Intrinsics.checkNotNullParameter((Object)resolvedAtom, (String)"resolvedAtom");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        Intrinsics.checkNotNullParameter((Object)resolutionCallbacks, (String)"resolutionCallbacks");
        CallableReferenceKotlinCallArgument argument = resolvedAtom.getAtom();
        UnwrappedType unwrappedType2 = resolvedAtom.getExpectedType();
        if (unwrappedType2 != null) {
            UnwrappedType unwrappedType3 = unwrappedType2;
            boolean bl = false;
            boolean bl2 = false;
            UnwrappedType it = unwrappedType3;
            boolean bl3 = false;
            TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
            if (typeSubstitutorMarker == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
            }
            unwrappedType = ((NewTypeSubstitutor)typeSubstitutorMarker).safeSubstitute(it);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType2 = unwrappedType;
        ImplicitScopeTower scopeTower = this.callComponents.getStatelessCallbacks().getScopeTowerForCallableReferenceArgument(argument);
        Set<CallableReferenceCandidate> candidates2 = this.runRHSResolution(scopeTower, argument, expectedType2, csBuilder, resolutionCallbacks, (Function1<? super Function1<? super ConstraintSystemOperation, Unit>, Unit>)((Function1)new Function1<Function1<? super ConstraintSystemOperation, ? extends Unit>, Unit>(csBuilder){
            final /* synthetic */ ConstraintSystemBuilder $csBuilder;

            public final void invoke(@NotNull Function1<? super ConstraintSystemOperation, Unit> checkCallableReference) {
                Intrinsics.checkNotNullParameter(checkCallableReference, (String)"checkCallableReference");
                this.$csBuilder.runTransaction((Function1<? super ConstraintSystemOperation, Boolean>)((Function1)new Function1<ConstraintSystemOperation, Boolean>(checkCallableReference){
                    final /* synthetic */ Function1 $checkCallableReference;

                    public final boolean invoke(@NotNull ConstraintSystemOperation $this$runTransaction) {
                        Intrinsics.checkNotNullParameter((Object)$this$runTransaction, (String)"$receiver");
                        this.$checkCallableReference.invoke((Object)$this$runTransaction);
                        return false;
                    }
                    {
                        this.$checkCallableReference = function1;
                        super(1);
                    }
                }));
            }
            {
                this.$csBuilder = constraintSystemBuilder;
                super(1);
            }
        }));
        if (candidates2.size() > 1 && resolvedAtom instanceof EagerCallableReferenceAtom) {
            boolean bl;
            block13: {
                Iterable $this$all$iv = candidates2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableReferenceCandidate it = (CallableReferenceCandidate)element$iv;
                        boolean bl4 = false;
                        if (TowerUtilsKt.isInapplicable(it.getResultingApplicability())) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
            if (bl) {
                diagnosticsHolder.addDiagnostic(new CallableReferenceCandidatesAmbiguity(argument, (Collection<CallableReferenceCandidate>)candidates2));
            }
            resolvedAtom.setAnalyzedResults(null, CollectionsKt.listOf((Object)((EagerCallableReferenceAtom)resolvedAtom).transformToPostponed()));
            return;
        }
        CallableReferenceCandidate chosenCandidate = (CallableReferenceCandidate)CollectionsKt.singleOrNull((Iterable)candidates2);
        if (chosenCandidate != null) {
            void toFreshSubstitutor;
            boolean it = false;
            boolean bl = false;
            CallableReferenceCandidate $this$with = chosenCandidate;
            boolean bl5 = false;
            Pair<FreshVariableNewTypeSubstitutor, KotlinCallDiagnostic> element$iv = CallableReferenceResolutionKt.checkCallableReference(csBuilder, argument, $this$with.getDispatchReceiver(), $this$with.getExtensionReceiver(), $this$with.getCandidate(), $this$with.getReflectionCandidateType(), expectedType2, scopeTower.getLexicalScope().getOwnerDescriptor());
            FreshVariableNewTypeSubstitutor $i$f$all = (FreshVariableNewTypeSubstitutor)element$iv.component1();
            KotlinCallDiagnostic diagnostic = (KotlinCallDiagnostic)element$iv.component2();
            ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, diagnostic);
            Iterable $this$forEach$iv = chosenCandidate.getDiagnostics();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                KotlinCallDiagnostic it2 = (KotlinCallDiagnostic)element$iv2;
                boolean bl6 = false;
                KotlinCallDiagnostic kotlinCallDiagnostic = it2;
                KotlinCallDiagnostic transformedDiagnostic = kotlinCallDiagnostic instanceof CompatibilityWarning ? (KotlinCallDiagnostic)new CompatibilityWarningOnArgument(argument, ((CompatibilityWarning)it2).getCandidate()) : it2;
                diagnosticsHolder.addDiagnostic(transformedDiagnostic);
            }
            chosenCandidate.setFreshSubstitutor$resolution((FreshVariableNewTypeSubstitutor)toFreshSubstitutor);
        } else if (candidates2.isEmpty()) {
            diagnosticsHolder.addDiagnostic(new NoneCallableReferenceCandidates(argument));
        } else {
            diagnosticsHolder.addDiagnostic(new CallableReferenceCandidatesAmbiguity(argument, (Collection<CallableReferenceCandidate>)candidates2));
        }
        List subKtArguments = CollectionsKt.listOfNotNull((Object)this.buildResolvedKtArgument(argument.getLhsResult()));
        resolvedAtom.setAnalyzedResults(chosenCandidate, subKtArguments);
    }

    private final ResolvedAtom buildResolvedKtArgument(LHSResult lhsResult) {
        ResolvedAtom resolvedAtom;
        if (!(lhsResult instanceof LHSResult.Expression)) {
            return null;
        }
        SimpleKotlinCallArgument lshCallArgument = ((LHSResult.Expression)lhsResult).getLshCallArgument();
        SimpleKotlinCallArgument simpleKotlinCallArgument = lshCallArgument;
        if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = ((SubKotlinCallArgument)lshCallArgument).getCallResult();
        } else if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = new ResolvedExpressionAtom((ExpressionKotlinCallArgument)lshCallArgument);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(lshCallArgument);
            throw null;
        }
        return resolvedAtom;
    }

    private final Set<CallableReferenceCandidate> runRHSResolution(ImplicitScopeTower scopeTower, CallableReferenceKotlinCallArgument callableReference, UnwrappedType expectedType2, ConstraintSystemBuilder csBuilder, KotlinResolutionCallbacks resolutionCallbacks, Function1<? super Function1<? super ConstraintSystemOperation, Unit>, Unit> compatibilityChecker) {
        CallableReferencesCandidateFactory factory2 = new CallableReferencesCandidateFactory(callableReference, this.callComponents, scopeTower, compatibilityChecker, expectedType2, csBuilder, resolutionCallbacks);
        ScopeTowerProcessor<CallableReferenceCandidate> processor2 = CallableReferenceResolutionKt.createCallableReferenceProcessor(factory2);
        Collection<CallableReferenceCandidate> candidates2 = this.towerResolver.runResolve(scopeTower, processor2, true, callableReference.getRhsName());
        return this.callableReferenceOverloadConflictResolver.chooseMaximallySpecificCandidates(candidates2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false);
    }

    public CallableReferenceResolver(@NotNull TowerResolver towerResolver, @NotNull CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter((Object)towerResolver, (String)"towerResolver");
        Intrinsics.checkNotNullParameter((Object)callableReferenceOverloadConflictResolver, (String)"callableReferenceOverloadConflictResolver");
        Intrinsics.checkNotNullParameter((Object)callComponents, (String)"callComponents");
        this.towerResolver = towerResolver;
        this.callableReferenceOverloadConflictResolver = callableReferenceOverloadConflictResolver;
        this.callComponents = callComponents;
    }
}

