/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public class OptimizationBasicInterpreter
extends Interpreter<BasicValue>
implements Opcodes {
    public OptimizationBasicInterpreter() {
        super(524288);
    }

    @Nullable
    public StrictBasicValue newValue(@Nullable Type type2) {
        if (type2 == null) {
            return StrictBasicValue.UNINITIALIZED_VALUE;
        }
        switch (type2.getSort()) {
            case 0: {
                return null;
            }
            case 5: {
                return StrictBasicValue.INT_VALUE;
            }
            case 6: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 7: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 8: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 1: {
                return StrictBasicValue.BOOLEAN_VALUE;
            }
            case 2: {
                return StrictBasicValue.CHAR_VALUE;
            }
            case 3: {
                return StrictBasicValue.BYTE_VALUE;
            }
            case 4: {
                return StrictBasicValue.SHORT_VALUE;
            }
            case 9: 
            case 10: {
                return new StrictBasicValue(type2);
            }
        }
        throw new IllegalArgumentException("Unknown type sort " + type2.getSort());
    }

    public BasicValue newOperation(@NotNull AbstractInsnNode insn) throws AnalyzerException {
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(0);
        }
        switch (insn.getOpcode()) {
            case 1: {
                return StrictBasicValue.NULL_VALUE;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return StrictBasicValue.INT_VALUE;
            }
            case 9: 
            case 10: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 11: 
            case 12: 
            case 13: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 14: 
            case 15: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 16: 
            case 17: {
                return StrictBasicValue.INT_VALUE;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return StrictBasicValue.INT_VALUE;
                }
                if (cst instanceof Float) {
                    return StrictBasicValue.FLOAT_VALUE;
                }
                if (cst instanceof Long) {
                    return StrictBasicValue.LONG_VALUE;
                }
                if (cst instanceof Double) {
                    return StrictBasicValue.DOUBLE_VALUE;
                }
                if (cst instanceof String) {
                    return this.newValue(Type.getObjectType((String)"java/lang/String"));
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9) {
                        return this.newValue(Type.getObjectType((String)"java/lang/Class"));
                    }
                    if (sort == 11) {
                        return this.newValue(Type.getObjectType((String)"java/lang/invoke/MethodType"));
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return this.newValue(Type.getObjectType((String)"java/lang/invoke/MethodHandle"));
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 178: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    public BasicValue copyOperation(@NotNull AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(1);
        }
        return value2;
    }

    public BasicValue binaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value1, @NotNull BasicValue value2) throws AnalyzerException {
        Type arrayType;
        if (insn == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(2);
        }
        if (value1 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(3);
        }
        if (value2 == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(4);
        }
        if (insn.getOpcode() == 50 && (arrayType = value1.getType()) != null && arrayType.getSort() == 9) {
            return new StrictBasicValue(AsmUtil.correctElementType(arrayType));
        }
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return StrictBasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 50: {
                return StrictBasicValue.REFERENCE_VALUE;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return StrictBasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        return null;
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            return this.newValue(Type.getType((String)((MultiANewArrayInsnNode)insn).desc));
        }
        if (opcode == 186) {
            return this.newValue(Type.getReturnType((String)((InvokeDynamicInsnNode)insn).desc));
        }
        return this.newValue(Type.getReturnType((String)((MethodInsnNode)insn).desc));
    }

    public void returnOperation(AbstractInsnNode insn, BasicValue value2, BasicValue expected) throws AnalyzerException {
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                return StrictBasicValue.INT_VALUE;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                return StrictBasicValue.FLOAT_VALUE;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                return StrictBasicValue.LONG_VALUE;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                return StrictBasicValue.DOUBLE_VALUE;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType((String)((FieldInsnNode)insn).desc));
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(Type.getType((String)"[Z"));
                    }
                    case 5: {
                        return this.newValue(Type.getType((String)"[C"));
                    }
                    case 8: {
                        return this.newValue(Type.getType((String)"[B"));
                    }
                    case 9: {
                        return this.newValue(Type.getType((String)"[S"));
                    }
                    case 10: {
                        return this.newValue(Type.getType((String)"[I"));
                    }
                    case 6: {
                        return this.newValue(Type.getType((String)"[F"));
                    }
                    case 7: {
                        return this.newValue(Type.getType((String)"[D"));
                    }
                    case 11: {
                        return this.newValue(Type.getType((String)"[J"));
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type");
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType((String)("[" + Type.getObjectType((String)desc))));
            }
            case 190: {
                return StrictBasicValue.INT_VALUE;
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getObjectType((String)desc));
            }
            case 193: {
                return StrictBasicValue.INT_VALUE;
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected instruction: " + InlineCodegenUtilsKt.getInsnOpcodeText(insn));
    }

    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        if (v == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(5);
        }
        if (w == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(6);
        }
        if (v.equals((Object)w)) {
            BasicValue basicValue = v;
            if (basicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(7);
            }
            return basicValue;
        }
        if (v == StrictBasicValue.UNINITIALIZED_VALUE || w == StrictBasicValue.UNINITIALIZED_VALUE) {
            StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
            if (strictBasicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(8);
            }
            return strictBasicValue;
        }
        if (OptimizationBasicInterpreter.isReference(v) && OptimizationBasicInterpreter.isReference(w)) {
            if (v == StrictBasicValue.NULL_VALUE) {
                StrictBasicValue strictBasicValue = this.newValue(w.getType());
                if (strictBasicValue == null) {
                    OptimizationBasicInterpreter.$$$reportNull$$$0(9);
                }
                return strictBasicValue;
            }
            if (w == StrictBasicValue.NULL_VALUE) {
                StrictBasicValue strictBasicValue = this.newValue(v.getType());
                if (strictBasicValue == null) {
                    OptimizationBasicInterpreter.$$$reportNull$$$0(10);
                }
                return strictBasicValue;
            }
            StrictBasicValue strictBasicValue = StrictBasicValue.REFERENCE_VALUE;
            if (strictBasicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(11);
            }
            return strictBasicValue;
        }
        if (v.getType().getOpcode(54) == 54 && w.getType().getOpcode(54) == 54) {
            StrictBasicValue strictBasicValue = StrictBasicValue.INT_VALUE;
            if (strictBasicValue == null) {
                OptimizationBasicInterpreter.$$$reportNull$$$0(12);
            }
            return strictBasicValue;
        }
        StrictBasicValue strictBasicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        if (strictBasicValue == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(13);
        }
        return strictBasicValue;
    }

    private static boolean isReference(@NotNull BasicValue v) {
        if (v == null) {
            OptimizationBasicInterpreter.$$$reportNull$$$0(14);
        }
        return v.getType().getSort() == 10 || v.getType().getSort() == 9;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newOperation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyOperation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "binaryOperation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReference";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

