/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.descriptors.WrappedDeclarationDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0011\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u00a6\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H&J\b\u0010%\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0000H\u0016J\u001c\u0010(\u001a\u00020\u001b2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001b0*H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "isCurrent", "", "()Z", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "moduleDependencies", "", "getModuleDependencies", "()Ljava/util/Collection;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "strategy", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "getStrategy", "()Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "addModuleReachableTopLevel", "", "idSig", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "contains", "declareIrSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "deserializeIrSymbol", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializeReachableDeclarations", "init", "delegate", "postProcess", "postProcessor", "Lkotlin/Function1;", "ir.serialization.common"})
public abstract class IrModuleDeserializer {
    @NotNull
    private final DeserializationStrategy strategy;
    private final boolean isCurrent;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;

    public abstract boolean contains(@NotNull IdSignature var1);

    @NotNull
    public abstract IrSymbol deserializeIrSymbol(@NotNull IdSignature var1, @NotNull BinarySymbolData.SymbolKind var2);

    public void declareIrSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        boolean bl = symbol2.isPublicApi();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Symbol is not public API: " + symbol2.getDescriptor();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        bl = !(symbol2.getDescriptor() instanceof WrappedDeclarationDescriptor);
        bl2 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        this.deserializeIrSymbol(symbol2.getSignature(), IrModuleDeserializerKt.kind(symbol2));
    }

    @NotNull
    public IrLibrary getKlib() {
        String string2 = "Unsupported operation";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    public void init() {
        this.init(this);
    }

    public void init(@NotNull IrModuleDeserializer delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
    }

    public void addModuleReachableTopLevel(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        String string2 = "Unsupported Operation (sig: " + idSig;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    public void deserializeReachableDeclarations() {
        String string2 = "Unsupported Operation";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    public void postProcess(@NotNull Function1<? super IrModuleFragment, Unit> postProcessor) {
        Intrinsics.checkNotNullParameter(postProcessor, (String)"postProcessor");
        postProcessor.invoke((Object)this.getModuleFragment());
    }

    @NotNull
    public abstract IrModuleFragment getModuleFragment();

    @NotNull
    public abstract Collection<IrModuleDeserializer> getModuleDependencies();

    @NotNull
    public DeserializationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isCurrent() {
        return this.isCurrent;
    }

    @NotNull
    public final ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    public IrModuleDeserializer(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        this.moduleDescriptor = moduleDescriptor;
        this.strategy = DeserializationStrategy.ONLY_DECLARATION_HEADERS;
    }
}

