/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryIds;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ErrorTriggeringExample;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public abstract class Rule {
    private static final Category MISC = new Category(CategoryIds.MISC, "Miscellaneous");
    protected final ResourceBundle messages;
    private List<CorrectExample> correctExamples;
    private List<IncorrectExample> incorrectExamples;
    private List<ErrorTriggeringExample> errorTriggeringExamples;
    private ITSIssueType locQualityIssueType = ITSIssueType.Uncategorized;
    private Category category;
    private URL url;
    private boolean defaultOff;
    private boolean defaultTempOff;
    private boolean officeDefaultOn = false;
    private boolean officeDefaultOff = false;

    public Rule() {
        this(null);
    }

    public Rule(ResourceBundle messages) {
        this.messages = messages;
        if (messages != null) {
            this.setCategory(Categories.MISC.getCategory(messages));
        } else {
            this.setCategory(MISC);
        }
    }

    public abstract String getId();

    public String getFullId() {
        return this.getId();
    }

    public abstract String getDescription();

    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    public int estimateContextForSureMatch() {
        return 0;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return Collections.emptyList();
    }

    public boolean hasConfigurableValue() {
        return false;
    }

    public int getDefaultValue() {
        return 0;
    }

    public int getMinConfigurableValue() {
        return 0;
    }

    public int getMaxConfigurableValue() {
        return 100;
    }

    public String getConfigureText() {
        return "";
    }

    protected AnalyzedSentence getSentenceWithImmunization(AnalyzedSentence sentence) {
        if (!this.getAntiPatterns().isEmpty()) {
            AnalyzedSentence immunizedSentence = sentence.copy(sentence);
            for (DisambiguationPatternRule patternRule : this.getAntiPatterns()) {
                try {
                    immunizedSentence = patternRule.replace(immunizedSentence);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return immunizedSentence;
        }
        return sentence;
    }

    protected List<DisambiguationPatternRule> makeAntiPatterns(List<List<PatternToken>> patternList, Language language) {
        ArrayList<DisambiguationPatternRule> rules = new ArrayList<DisambiguationPatternRule>();
        for (List<PatternToken> patternTokens : patternList) {
            rules.add(new DisambiguationPatternRule("INTERNAL_ANTIPATTERN", "(no description)", language, patternTokens, null, null, DisambiguationPatternRule.DisambiguatorAction.IMMUNIZE));
        }
        return rules;
    }

    public boolean supportsLanguage(Language language) {
        try {
            ArrayList relevantRuleClasses = new ArrayList();
            UserConfig config = new UserConfig();
            ArrayList<Rule> relevantRules = new ArrayList<Rule>(language.getRelevantRules(JLanguageTool.getMessageBundle(), config, null, Collections.emptyList()));
            relevantRules.addAll(language.getRelevantLanguageModelCapableRules(JLanguageTool.getMessageBundle(), null, null, config, null, Collections.emptyList()));
            for (Rule relevantRule : relevantRules) {
                relevantRuleClasses.add(relevantRule.getClass());
            }
            return relevantRuleClasses.contains(this.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isDictionaryBasedSpellingRule() {
        return false;
    }

    public boolean useInOffice() {
        return false;
    }

    public final void setCorrectExamples(List<CorrectExample> correctExamples) {
        this.correctExamples = Objects.requireNonNull(correctExamples);
    }

    public final List<CorrectExample> getCorrectExamples() {
        return this.correctExamples == null ? Collections.emptyList() : Collections.unmodifiableList(this.correctExamples);
    }

    public final void setIncorrectExamples(List<IncorrectExample> incorrectExamples) {
        this.incorrectExamples = Objects.requireNonNull(incorrectExamples);
    }

    public final List<IncorrectExample> getIncorrectExamples() {
        return this.incorrectExamples == null ? Collections.emptyList() : Collections.unmodifiableList(this.incorrectExamples);
    }

    public final void setErrorTriggeringExamples(List<ErrorTriggeringExample> examples) {
        this.errorTriggeringExamples = Objects.requireNonNull(examples);
    }

    public final List<ErrorTriggeringExample> getErrorTriggeringExamples() {
        return this.errorTriggeringExamples == null ? Collections.emptyList() : Collections.unmodifiableList(this.errorTriggeringExamples);
    }

    public final Category getCategory() {
        return this.category;
    }

    public final void setCategory(Category category) {
        this.category = Objects.requireNonNull(category, "category cannot be null");
    }

    protected final RuleMatch[] toRuleMatchArray(List<RuleMatch> ruleMatches) {
        return ruleMatches.toArray(new RuleMatch[0]);
    }

    public final boolean isDefaultOff() {
        return this.defaultOff;
    }

    public final boolean isDefaultTempOff() {
        return this.defaultTempOff;
    }

    public final void setDefaultOff() {
        this.defaultOff = true;
    }

    public final void setDefaultTempOff() {
        this.defaultOff = true;
        this.defaultTempOff = true;
    }

    public final void setDefaultOn() {
        this.defaultOff = false;
    }

    public final boolean isOfficeDefaultOff() {
        return this.officeDefaultOff;
    }

    public final boolean isOfficeDefaultOn() {
        return this.officeDefaultOn;
    }

    public final void setOfficeDefaultOff() {
        this.officeDefaultOff = true;
    }

    public final void setOfficeDefaultOn() {
        this.officeDefaultOn = true;
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public ITSIssueType getLocQualityIssueType() {
        return this.locQualityIssueType;
    }

    public void setLocQualityIssueType(ITSIssueType locQualityIssueType) {
        this.locQualityIssueType = Objects.requireNonNull(locQualityIssueType);
    }

    protected void addExamplePair(IncorrectExample incorrectSentence, CorrectExample correctSentence) {
        if (this.correctExamples == null) {
            this.correctExamples = new ArrayList<CorrectExample>(0);
        }
        if (this.incorrectExamples == null) {
            this.incorrectExamples = new ArrayList<IncorrectExample>(0);
        }
        String correctExample = correctSentence.getExample();
        int markerStart = correctExample.indexOf("<marker>");
        int markerEnd = correctExample.indexOf("</marker>");
        if (markerStart != -1 && markerEnd != -1) {
            List<String> correction = Collections.singletonList(correctExample.substring(markerStart + "<marker>".length(), markerEnd));
            this.incorrectExamples.add(new IncorrectExample(incorrectSentence.getExample(), correction));
        } else {
            this.incorrectExamples.add(incorrectSentence);
        }
        this.correctExamples.add(correctSentence);
    }

    protected void setExamplePair(IncorrectExample incorrectSentence, CorrectExample correctSentence) {
        if (this.incorrectExamples != null) {
            this.incorrectExamples.clear();
        }
        if (correctSentence != null) {
            this.correctExamples.clear();
        }
        this.addExamplePair(incorrectSentence, correctSentence);
    }
}

