/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinUpdatePluginStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "requestFullJarUpdate", "", "jarFilePath", "Ljava/io/File;", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.idea"})
public final class KotlinUpdatePluginStartupActivity
implements StartupActivity {
    private static final String INSTALLED_KOTLIN_VERSION = "installed.kotlin.plugin.version";
    public static final Companion Companion = new Companion(null);

    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        if (propertiesComponent == null) {
            return;
        }
        PropertiesComponent propertiesComponent2 = propertiesComponent;
        String installedKotlinVersion = propertiesComponent2.getValue(INSTALLED_KOTLIN_VERSION);
        if (Intrinsics.areEqual((Object)KotlinPluginUtil.getPluginVersion(), (Object)installedKotlinVersion) ^ true) {
            for (LibraryJarDescriptor libraryJarDescriptor : LibraryJarDescriptor.values()) {
                this.requestFullJarUpdate(libraryJarDescriptor.getPathInPlugin());
            }
            propertiesComponent2.setValue(INSTALLED_KOTLIN_VERSION, KotlinPluginUtil.getPluginVersion());
        }
    }

    private final void requestFullJarUpdate(File jarFilePath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(jarFilePath);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026le(jarFilePath) ?: return");
        VirtualFile localVirtualFile = virtualFile;
        VirtualFile virtualFile2 = JarFileSystem.getInstance().getJarRootForLocalFile(localVirtualFile);
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"JarFileSystem.getInstanc\u2026calVirtualFile) ?: return");
        VirtualFile jarFile = virtualFile2;
        VfsUtilCore.visitChildrenRecursively((VirtualFile)jarFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){}));
        VirtualFile virtualFile3 = jarFile;
        if (virtualFile3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
        }
        ((NewVirtualFile)virtualFile3).markDirtyRecursively();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/versions/KotlinUpdatePluginStartupActivity$Companion;", "", "()V", "INSTALLED_KOTLIN_VERSION", "", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

