/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.testIntegration.JavaTestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.testIntegration.KotlinTestFinder$findSourceElement$;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/testIntegration/KotlinTestFinder;", "Lcom/intellij/testIntegration/JavaTestFinder;", "()V", "findClassesForTest", "", "Lcom/intellij/psi/PsiElement;", "element", "findSourceElement", "Lcom/intellij/psi/PsiClass;", "from", "findTestsForClass", "isTest", "", "kotlin.idea"})
public final class KotlinTestFinder
extends JavaTestFinder {
    @Nullable
    public PsiClass findSourceElement(@NotNull PsiElement from) {
        Object v2;
        block5: {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            PsiClass psiClass2 = super.findSourceElement(from);
            if (psiClass2 != null) {
                PsiClass psiClass3 = psiClass2;
                boolean bl = false;
                boolean bl2 = false;
                PsiClass it = psiClass3;
                boolean bl3 = false;
                return it;
            }
            Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)from);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findSourceElement$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence $this$firstOrNull$iv = sequence;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl = false;
                if (!(!it.isLocal())) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        KtClassOrObject ktClassOrObject = v2;
        if (ktClassOrObject != null) {
            KtClassOrObject ktClassOrObject2 = ktClassOrObject;
            boolean bl = false;
            boolean bl4 = false;
            KtClassOrObject it = ktClassOrObject2;
            boolean bl5 = false;
            return ResolutionUtils.resolveToDescriptorIfAny$default((KtClassOrObject)it, null, (int)1, null) == null ? null : (PsiClass)LightClassUtilsKt.toLightClass((KtClassOrObject)it);
        }
        PsiFile psiFile = from.getContainingFile();
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        return (PsiClass)(ktFile != null ? LightClassUtilsKt.findFacadeClass((KtFile)ktFile) : null);
    }

    public boolean isTest(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return false;
        }
        PsiClass sourceElement = psiClass2;
        return super.isTest((PsiElement)sourceElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass2;
        GlobalSearchScope scope2 = this.getSearchScope(element3, true);
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)element3.getProject());
        TestFrameworks frameworks = TestFrameworks.getInstance();
        ArrayList<Pair> classesWithWeights = new ArrayList<Pair>();
        for (Pair candidateNameWithWeight : TestFinderHelper.collectPossibleClassNamesWithWeights((String)klass2.getName())) {
            PsiClass[] psiClassArray = cache.getClassesByName((String)candidateNameWithWeight.first, scope2);
            int n = psiClassArray.length;
            for (int i = 0; i < n; ++i) {
                PsiClass eachClass;
                PsiClass psiClass3 = eachClass = psiClassArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"eachClass");
                if (psiClass3.isAnnotationType() || frameworks.isTestClass(eachClass)) continue;
                if (eachClass instanceof KtLightClassForFacade) {
                    Iterable $this$mapTo$iv = ((KtLightClassForFacade)eachClass).getFiles();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        KtFile ktFile = (KtFile)item$iv;
                        Collection collection = classesWithWeights;
                        boolean bl = false;
                        Pair pair = Pair.create((Object)it, (Object)candidateNameWithWeight.second);
                        collection.add(pair);
                    }
                    continue;
                }
                if (!eachClass.isPhysical() && !(eachClass instanceof KtLightClassForSourceDeclaration)) continue;
                classesWithWeights.add(Pair.create((Object)eachClass, (Object)candidateNameWithWeight.second));
            }
        }
        List list = TestFinderHelper.getSortedElements((List)classesWithWeights, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"TestFinderHelper.getSort\u2026lassesWithWeights, false)");
        return list;
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiClass psiClass2 = this.findSourceElement(element3);
        if (psiClass2 == null) {
            return SetsKt.emptySet();
        }
        PsiClass klass2 = psiClass2;
        ArrayList classesWithProximities = new ArrayList();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor((Collection)classesWithProximities);
        String string = klass2.getName();
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"klass.name!!");
        String klassName = string;
        Pattern pattern = Pattern.compile(".*" + StringUtil.escapeToRegexp((String)klassName) + ".*", 2);
        GlobalSearchScope scope2 = this.getSearchScope((PsiElement)klass2, false);
        TestFrameworks frameworks = TestFrameworks.getInstance();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)klass2.getProject());
        cache.processAllClassNames((Processor)new Processor<String>(pattern, cache, scope2, frameworks, processor2, klassName){
            final /* synthetic */ Pattern $pattern;
            final /* synthetic */ PsiShortNamesCache $cache;
            final /* synthetic */ GlobalSearchScope $scope;
            final /* synthetic */ TestFrameworks $frameworks;
            final /* synthetic */ CommonProcessors.CollectProcessor $processor;
            final /* synthetic */ String $klassName;

            public final boolean process(String candidateName) {
                if (!this.$pattern.matcher(candidateName).matches()) {
                    return true;
                }
                for (PsiClass candidateClass : this.$cache.getClassesByName(candidateName, this.$scope)) {
                    if (!this.$frameworks.isTestClass(candidateClass) && !this.$frameworks.isPotentialTestClass(candidateClass)) {
                        return true;
                    }
                    PsiClass psiClass2 = candidateClass;
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass2, (String)"candidateClass");
                    if (!psiClass2.isPhysical() && !(candidateClass instanceof KtLightClassForSourceDeclaration)) {
                        return true;
                    }
                    if (this.$processor.process((Object)Pair.create((Object)candidateClass, (Object)TestFinderHelper.calcTestNameProximity((String)this.$klassName, (String)candidateName)))) continue;
                    return false;
                }
                return true;
            }
            {
                this.$pattern = pattern;
                this.$cache = psiShortNamesCache;
                this.$scope = globalSearchScope;
                this.$frameworks = testFrameworks;
                this.$processor = collectProcessor;
                this.$klassName = string;
            }
        });
        List list = TestFinderHelper.getSortedElements((List)classesWithProximities, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"TestFinderHelper.getSort\u2026sesWithProximities, true)");
        return list;
    }
}

