/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.ui;

import com.intellij.ide.util.AbstractTreeClassChooserDialog;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNode;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/ui/KotlinFileChooserDialog;", "Lcom/intellij/ide/util/AbstractTreeClassChooserDialog;", "Lorg/jetbrains/kotlin/psi/KtFile;", "title", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "createChooseByNameModel", "Lcom/intellij/ide/util/gotoByName/GotoFileModel;", "getClassesByName", "", "name", "checkBoxState", "", "pattern", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getSelectedFromTreeUserObject", "node", "Ljavax/swing/tree/DefaultMutableTreeNode;", "kotlin.idea"})
public final class KotlinFileChooserDialog
extends AbstractTreeClassChooserDialog<KtFile> {
    @Nullable
    protected KtFile getSelectedFromTreeUserObject(@NotNull DefaultMutableTreeNode node) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object userObject = node.getUserObject();
        if (userObject instanceof KtFileTreeNode) {
            object = ((KtFileTreeNode)((Object)userObject)).getKtFile();
        } else if (userObject instanceof KtClassOrObjectTreeNode) {
            KtClassOrObject ktClassOrObject = (KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)ktClassOrObject, (String)"userObject.value");
            KtFile ktFile = ktClassOrObject.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"userObject.value.containingKtFile");
            KtFile containingFile = ktFile;
            object = containingFile.getDeclarations().size() == 1 ? containingFile : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<KtFile> getClassesByName(@NotNull String name2, boolean checkBoxState, @NotNull String pattern, @NotNull GlobalSearchScope searchScope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)this.getProject(), (String)name2, (GlobalSearchScope)searchScope);
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"FilenameIndex.getFilesBy\u2026oject, name, searchScope)");
        PsiFile[] $this$filterIsInstance$iv = psiFileArray;
        boolean $i$f$filterIsInstance = false;
        PsiFile[] psiFileArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected GotoFileModel createChooseByNameModel() {
        return new GotoFileModel(this.getProject());
    }

    public KotlinFileChooserDialog(@NlsContexts.DialogTitle @NotNull String title, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(title, project2, SearchUtilKt.restrictToKotlinSources((GlobalSearchScope)SearchUtilKt.projectScope((Project)project2)), KtFile.class, null, null, null, false, false);
    }
}

