/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveMethod;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinIconProviderBase;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.core.completion.PackageLookupObject;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveMethod.MoveKotlinMethodProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinTypeReferenceEditorComboWithBrowseButton;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public class MoveKotlinMethodDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = MoveKotlinMethodDialog.class.getName() + ".RECENTS_KEY";
    private final KtNamedFunction method;
    private final Map<KtNamedDeclaration, KtClass> variableToClassMap;
    private final KtNamedDeclaration[] variables;
    private final Map<KtClass, Set<KtNamedDeclaration>> thisClassesToMembers;
    private final KtClassOrObject targetContainer;
    private final Map<KtClass, EditorTextField> oldClassParameterNameFields;
    private KtNamedDeclaration selectedTarget;
    private JPanel mainPanel;
    private JRadioButton toClassRadioButton;
    private JRadioButton toObjectRadioButton;
    private JPanel targetObjectChooserPanel;
    private KotlinTypeReferenceEditorComboWithBrowseButton targetObjectChooser;
    private JList<KtNamedDeclaration> targetVariableList;
    private JPanel targetVariableListPanel;
    private JPanel parametersPanel;
    private JCheckBox openInEditorCheckBox;

    public MoveKotlinMethodDialog(@NotNull KtNamedFunction method, @NotNull Map<KtNamedDeclaration, KtClass> variableToClassMap, @Nullable KtClassOrObject targetContainer) {
        if (method == null) {
            MoveKotlinMethodDialog.$$$reportNull$$$0(0);
        }
        if (variableToClassMap == null) {
            MoveKotlinMethodDialog.$$$reportNull$$$0(1);
        }
        super(method.getProject(), true);
        this.method = method;
        this.variableToClassMap = variableToClassMap;
        this.targetContainer = targetContainer;
        this.$$$setupUI$$$();
        this.thisClassesToMembers = MoveKotlinMethodProcessorKt.getThisClassesToMembers(method);
        this.variables = variableToClassMap.keySet().toArray(new KtNamedDeclaration[0]);
        this.oldClassParameterNameFields = new HashMap<KtClass, EditorTextField>();
        this.init();
        this.setTitle(KotlinBundle.message("title.move.method", new Object[0]));
        this.initTargetObjectChooser();
        this.initTargetVariableList();
        this.initParametersPanel();
        this.initButtons();
    }

    protected void doAction() {
        if (this.toClassRadioButton.isSelected()) {
            this.selectedTarget = this.targetVariableList.getSelectedValue();
        }
        if (this.toObjectRadioButton.isSelected() && this.selectedTarget == null) {
            this.setErrorText(KotlinBundle.message("text.no.destination.object.specified", new Object[0]));
            return;
        }
        LinkedHashMap<KtClass, String> oldClassParameterNames = new LinkedHashMap<KtClass, String>();
        for (Map.Entry<KtClass, EditorTextField> entry : this.oldClassParameterNameFields.entrySet()) {
            EditorTextField field2 = entry.getValue();
            if (!Name.isValidIdentifier((String)field2.getText())) {
                this.setErrorText(KotlinBundle.message("parameter.name.is.invalid", field2.getText()));
                return;
            }
            if (!field2.isEnabled()) continue;
            oldClassParameterNames.put(entry.getKey(), field2.getText());
        }
        MoveKotlinMethodProcessor processor2 = new MoveKotlinMethodProcessor(this.method, this.selectedTarget, oldClassParameterNames, this.openInEditorCheckBox.isSelected());
        this.invokeRefactoring(processor2);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    private void initButtons() {
        this.toClassRadioButton.addActionListener(e -> this.enableTargetChooser());
        this.toObjectRadioButton.addActionListener(e -> this.enableTargetChooser());
        if (this.variables.length != 0 && !(this.targetContainer instanceof KtObjectDeclaration)) {
            this.toClassRadioButton.setSelected(true);
        } else {
            this.toObjectRadioButton.setSelected(true);
            if (this.variables.length == 0) {
                this.toClassRadioButton.setEnabled(false);
            }
        }
        this.enableTextFields();
        this.enableTargetChooser();
    }

    private void initTargetVariableList() {
        AbstractListModel<KtNamedDeclaration> listModel = new AbstractListModel<KtNamedDeclaration>(){

            @Override
            public int getSize() {
                return MoveKotlinMethodDialog.this.variables.length;
            }

            @Override
            public KtNamedDeclaration getElementAt(int index) {
                return MoveKotlinMethodDialog.this.variables[index];
            }
        };
        this.targetVariableList = new JBList((ListModel)listModel);
        DefaultListCellRenderer listCellRenderer = new DefaultListCellRenderer(){
            private final DescriptorRenderer renderer = IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof KtNamedDeclaration) {
                    KtNamedDeclaration variable2 = (KtNamedDeclaration)value;
                    this.setIcon(KotlinIconProviderBase.Companion.getBaseIcon((PsiElement)variable2));
                    this.setText(variable2.getName());
                    KotlinType type2 = MoveKotlinMethodProcessorKt.type(variable2);
                    if (type2 != null) {
                        this.setText(this.getText() + ": " + this.renderer.renderType(type2));
                    }
                }
                return this;
            }
        };
        this.targetVariableList.setCellRenderer(listCellRenderer);
        this.targetVariableList.setSelectionMode(0);
        int defaultVariableIndex = -1;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variableToClassMap.get(this.variables[i]) != this.targetContainer) continue;
            defaultVariableIndex = i;
        }
        this.targetVariableList.setSelectedIndex(defaultVariableIndex != -1 ? defaultVariableIndex : 0);
        this.targetVariableList.getSelectionModel().addListSelectionListener(e -> this.enableTextFields());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.targetVariableList);
        this.targetVariableListPanel.add(scrollPane);
    }

    private void initTargetObjectChooser() {
        this.targetObjectChooser = new KotlinTypeReferenceEditorComboWithBrowseButton(e -> {
            TreeJavaClassChooserDialog chooser2 = this.createTreeClassChooser();
            chooser2.selectDirectory(this.method.getContainingFile().getContainingDirectory());
            chooser2.showDialog();
            PsiClass psiClass2 = chooser2.getSelected();
            if (psiClass2 instanceof KtLightClassForSourceDeclaration) {
                this.selectedTarget = ((KtLightClassForSourceDeclaration)psiClass2).getKotlinOrigin();
                this.targetObjectChooser.setText(Objects.requireNonNull(psiClass2.getQualifiedName()));
            }
        }, this.targetContainer == null || this.targetContainer.getFqName() == null ? null : this.targetContainer.getFqName().asString(), (PsiElement)(this.targetContainer == null ? (PsiElement)Objects.requireNonNull(KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)this.method)) : this.targetContainer), RECENTS_KEY);
        KtTypeCodeFragment codeFragment = this.targetObjectChooser.getCodeFragment();
        if (codeFragment != null) {
            CompletionUtilsKt.setExtraCompletionFilter((KtCodeFragment)codeFragment, (Function1<? super LookupElement, Boolean>)((Function1)lookupElement2 -> {
                Object lookupObject2 = lookupElement2.getObject();
                if (!(lookupObject2 instanceof DeclarationLookupObject)) {
                    return false;
                }
                PsiElement psiElement2 = ((DeclarationLookupObject)lookupObject2).getPsiElement();
                if (lookupObject2 instanceof PackageLookupObject) {
                    return true;
                }
                return psiElement2 instanceof KtObjectDeclaration && KotlinRefactoringUtilKt.canRefactor(psiElement2);
            }));
        }
        this.targetObjectChooserPanel.add((Component)((Object)this.targetObjectChooser));
    }

    private void enableTextFields() {
        for (EditorTextField textField : this.oldClassParameterNameFields.values()) {
            textField.setEnabled(true);
        }
        if (this.toClassRadioButton.isSelected()) {
            EditorTextField field2;
            Set<KtNamedDeclaration> members2;
            KtNamedDeclaration variable2 = this.variables[this.targetVariableList.getSelectedIndex()];
            KtClassOrObject containingClass = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)variable2);
            if (!(containingClass instanceof KtClass)) {
                return;
            }
            if ((!(variable2 instanceof KtParameter) || ((KtParameter)variable2).hasValOrVar()) && (members2 = this.thisClassesToMembers.get(containingClass)) != null && members2.size() == 1 && members2.contains(variable2) && (field2 = this.oldClassParameterNameFields.get(containingClass)) != null) {
                field2.setEnabled(false);
            }
        }
    }

    private void enableTargetChooser() {
        if (this.toClassRadioButton.isSelected()) {
            this.targetVariableList.setEnabled(true);
            this.targetObjectChooser.setEnabled(false);
        } else {
            this.targetVariableList.setEnabled(false);
            this.targetObjectChooser.setEnabled(true);
        }
        this.enableTextFields();
    }

    private void initParametersPanel() {
        if (this.thisClassesToMembers.isEmpty()) {
            return;
        }
        this.parametersPanel.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
        NewDeclarationNameValidator validator2 = new NewDeclarationNameValidator((PsiElement)this.method, null, NewDeclarationNameValidator.Target.VARIABLES, new ArrayList());
        for (KtClass ktClass2 : this.thisClassesToMembers.keySet()) {
            SimpleType type2 = MoveKotlinMethodProcessorKt.defaultType(ktClass2);
            if (type2 == null) continue;
            String text2 = KotlinBundle.message("text.select.a.name.for.this.parameter", ktClass2.getName());
            this.parametersPanel.add((Component)new TitledSeparator(text2, null));
            List suggestedNames2 = KotlinNameSuggester.INSTANCE.suggestNamesByType((KotlinType)type2, (Function1)validator2, null);
            String suggestedName2 = suggestedNames2.isEmpty() ? "parameter" : (String)suggestedNames2.get(0);
            EditorTextField field2 = new EditorTextField(suggestedName2, this.myProject, (FileType)KotlinFileType.INSTANCE);
            this.oldClassParameterNameFields.put(ktClass2, field2);
            this.parametersPanel.add((Component)field2);
        }
    }

    private TreeJavaClassChooserDialog createTreeClassChooser() {
        return new TreeJavaClassChooserDialog(KotlinBundle.message("title.choose.destination.object", new Object[0]), this.myProject, GlobalSearchScope.projectScope((Project)this.myProject), aClass -> {
            if (!(aClass instanceof KtLightClassForSourceDeclaration)) {
                return false;
            }
            KtClassOrObject ktClassOrObject = ((KtLightClassForSourceDeclaration)aClass).getKotlinOrigin();
            return ktClassOrObject instanceof KtObjectDeclaration && !((KtObjectDeclaration)ktClassOrObject).isObjectLiteral();
        }, null, null, true){

            @Nullable
            protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
                PsiClass psiClass2 = super.getSelectedFromTreeUserObject(node);
                if (psiClass2 != null) {
                    return psiClass2;
                }
                Object userObject = node.getUserObject();
                if (!(userObject instanceof KtClassOrObjectTreeNode)) {
                    return null;
                }
                return LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue()));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "variableToClassMap";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveMethod/MoveKotlinMethodDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JPanel jPanel3;
        JPanel jPanel4;
        JRadioButton jRadioButton2;
        JPanel jPanel5;
        this.mainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toObjectRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("label.text.to.object"));
        jPanel6.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.targetObjectChooserPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.parametersPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.toClassRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("label.text.to.class"));
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.targetVariableListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        this.openInEditorCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/KotlinBundle", MoveKotlinMethodDialog.class).getString("open.moved.method.in.editor"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

