/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.ReplacePromptDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiRange;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a(\u0010\r\u001a\u00020\u00012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"processDuplicates", "", "duplicateReplacers", "", "Lorg/jetbrains/kotlin/idea/util/psi/patternMatching/KotlinPsiRange;", "Lkotlin/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "scopeDescription", "", "usageDescription", "processDuplicatesSilently", "highlight", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "preview", "kotlin.idea"})
public final class DuplicateUtilKt {
    @Nullable
    public static final RangeHighlighter highlight(@NotNull KotlinPsiRange $this$highlight, @NotNull Project project2, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)$this$highlight, (String)"$this$highlight");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextRange textRange = IntroduceUtilKt.getPhysicalTextRange($this$highlight);
        ArrayList highlighters = new ArrayList();
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Intrinsics.checkNotNull((Object)textAttributes);
        TextAttributes attributes = textAttributes;
        HighlightManager.getInstance((Project)project2).addRangeHighlight(editor2, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, (Collection)highlighters);
        return (RangeHighlighter)CollectionsKt.firstOrNull((List)highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangeHighlighter preview(@NotNull KotlinPsiRange $this$preview, @NotNull Project project2, @NotNull Editor editor2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$preview, (String)"$this$preview");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        RangeHighlighter rangeHighlighter = DuplicateUtilKt.highlight($this$preview, project2, editor2);
        if (rangeHighlighter == null) {
            return null;
        }
        RangeHighlighter highlight = rangeHighlighter;
        int startOffset = IntroduceUtilKt.getPhysicalTextRange($this$preview).getStartOffset();
        FoldRegion[] foldRegionArray = CodeFoldingManager.getInstance((Project)project2).getFoldRegionsAtOffset(editor2, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"CodeFoldingManager.getIn\u2026fset(editor, startOffset)");
        FoldRegion[] $this$filter$iv = foldRegionArray;
        boolean $i$f$filter = false;
        FoldRegion[] foldRegionArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_10 = $this$filterTo$iv$iv;
        int n = ((void)var11_10).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var11_10[i];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            if (!(!v2.isExpanded())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List foldedRegions = (List)destination$iv$iv;
        if (!foldedRegions.isEmpty()) {
            editor2.getFoldingModel().runBatchFoldingOperation(new Runnable(foldedRegions){
                final /* synthetic */ List $foldedRegions;

                public final void run() {
                    Iterable $this$forEach$iv = this.$foldedRegions;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FoldRegion it = (FoldRegion)element$iv;
                        boolean bl = false;
                        FoldRegion foldRegion = it;
                        Intrinsics.checkNotNullExpressionValue((Object)foldRegion, (String)"it");
                        foldRegion.setExpanded(true);
                    }
                }
                {
                    this.$foldedRegions = list;
                }
            });
        }
        editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
        return highlight;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final void processDuplicates(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers, @NotNull Project project2, @NotNull Editor editor2, @NotNull String scopeDescription, @NotNull String usageDescription) {
        int answer;
        int n;
        Intrinsics.checkNotNullParameter(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)scopeDescription, (String)"scopeDescription");
        Intrinsics.checkNotNullParameter((Object)usageDescription, (String)"usageDescription");
        int size = duplicateReplacers.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            DuplicateUtilKt.preview((KotlinPsiRange)CollectionsKt.first((Iterable)duplicateReplacers.keySet()), project2, editor2);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application);
        if (application.isUnitTestMode()) {
            n = 0;
        } else {
            Object[] objectArray = new Object[4];
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            String string = applicationNamesInfo.getProductName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationNamesInfo.getInstance().productName");
            objectArray[0] = string;
            objectArray[1] = duplicateReplacers.size();
            objectArray[2] = scopeDescription;
            objectArray[3] = usageDescription;
            n = answer = Messages.showYesNoDialog((Project)project2, (String)KotlinBundle.message("0.has.detected.1.code.fragments.in.2.that.can.be.replaced.with.3", objectArray), (String)KotlinBundle.message("text.process.duplicates", new Object[0]), (Icon)Messages.getQuestionIcon());
        }
        if (answer != 0) {
            return;
        }
        boolean showAll = false;
        boolean bl = false;
        Iterator iterator = ((Iterable)duplicateReplacers.entrySet()).iterator();
        while (true) {
            void i;
            block13: {
                RangeHighlighter highlighter;
                Function0 replacer;
                boolean bl2;
                Map.Entry entry;
                block14: {
                    void pattern;
                    Map.Entry entry2;
                    Map.Entry entry3;
                    if (!iterator.hasNext()) {
                        return;
                    }
                    entry = entry3 = (entry2 = (Map.Entry)iterator.next());
                    bl2 = false;
                    KotlinPsiRange kotlinPsiRange = (KotlinPsiRange)entry.getKey();
                    entry = entry3;
                    bl2 = false;
                    replacer = (Function0)entry.getValue();
                    if (!pattern.isValid()) break block13;
                    highlighter = DuplicateUtilKt.preview((KotlinPsiRange)pattern, project2, editor2);
                    Application application2 = ApplicationManager.getApplication();
                    Intrinsics.checkNotNull((Object)application2);
                    if (application2.isUnitTestMode() || size <= 1 || showAll) break block14;
                    ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{(int)(i + true), size}), project2);
                    promptDialog.show();
                    switch (promptDialog.getExitCode()) {
                        case 3: {
                            showAll = true;
                            break;
                        }
                        case 2: {
                            break block13;
                        }
                        case 1: {
                            return;
                        }
                    }
                }
                RangeHighlighter rangeHighlighter = highlighter;
                if (rangeHighlighter != null) {
                    entry = rangeHighlighter;
                    bl2 = false;
                    boolean bl3 = false;
                    Map.Entry it = entry;
                    boolean bl4 = false;
                    HighlightManager.getInstance((Project)project2).removeSegmentHighlighter(editor2, (RangeHighlighter)it);
                }
                ApplicationUtilsKt.executeWriteCommand((Project)project2, (String)"Replace Code Duplicates", (Function0)replacer);
            }
            ++i;
        }
    }

    public static /* synthetic */ void processDuplicates$default(Map map2, Project project2, Editor editor2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string = "this file";
        }
        if ((n & 0x10) != 0) {
            string2 = "a usage of extracted declaration";
        }
        DuplicateUtilKt.processDuplicates(map2, project2, editor2, string, string2);
    }

    public static final void processDuplicatesSilently(@NotNull Map<KotlinPsiRange, ? extends Function0<Unit>> duplicateReplacers, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ApplicationUtilsKt.executeWriteCommand((Project)project2, (String)"Replace Code Duplicates", (Function0)((Function0)new Function0<Unit>(duplicateReplacers){
            final /* synthetic */ Map $duplicateReplacers;

            public final void invoke() {
                Iterable $this$forEach$iv = this.$duplicateReplacers.values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
            {
                this.$duplicateReplacers = map2;
                super(0);
            }
        }));
    }
}

