/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CompilerSettingsKt;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.quickfix.ExperimentalFixesFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.roots.RootUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUsageChecker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J#\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0003\u001a\u00020\u0002H\u0094\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0003\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleExperimentalFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "module", "Lcom/intellij/openapi/module/Module;", "annotationFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/name/FqName;)V", "compilerArgument", "", "experimentalPrefix", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "Companion", "kotlin.idea"})
public final class MakeModuleExperimentalFix
extends KotlinQuickFixAction<KtFile> {
    private final String experimentalPrefix;
    private final String compilerArgument;
    private final Module module;
    private final FqName annotationFqName;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.compilerArgument;
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.name");
        objectArray[1] = string;
        return KotlinBundle.message("add.0.to.module.1.compiler.arguments", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("add.an.opt.in.requirement.marker.compiler.argument", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(project2);
        try {
            CompilerSettings compilerSettings;
            KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(this.module, (IdeModifiableModelsProvider)modelsProvider, false, null, true, 4, null);
            KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
            CompilerSettings compilerSettings2 = facetSettings.getCompilerSettings();
            if (compilerSettings2 == null) {
                CompilerSettings compilerSettings3 = new CompilerSettings();
                boolean bl = false;
                boolean bl2 = false;
                CompilerSettings it = compilerSettings3;
                boolean bl3 = false;
                facetSettings.setCompilerSettings(it);
                compilerSettings2 = compilerSettings3;
            }
            CompilerSettings compilerSettings4 = compilerSettings = compilerSettings2;
            compilerSettings4.setAdditionalArguments(compilerSettings4.getAdditionalArguments() + ' ' + this.compilerArgument);
            facetSettings.updateMergedArguments();
            RootUtilsKt.invalidateProjectRoots((Project)project2);
        }
        finally {
            modelsProvider.dispose();
        }
    }

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (Intrinsics.areEqual((Object)BuildSystemTypeKt.getBuildSystemType((Module)this.module), (Object)BuildSystemType.JPS.INSTANCE) ^ true) {
                return false;
            }
            KotlinFacet kotlinFacet = KotlinFacet.Companion.get(this.module);
            if (kotlinFacet == null) {
                return true;
            }
            KotlinFacet facet = kotlinFacet;
            KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
            CompilerSettings compilerSettings = facetSettings.getCompilerSettings();
            if (compilerSettings == null) {
                return true;
            }
            CompilerSettings compilerSettings2 = compilerSettings;
            if (Intrinsics.areEqual((Object)this.annotationFqName, (Object)ExperimentalUsageChecker.Companion.getREQUIRES_OPT_IN_FQ_NAME()) ^ true && Intrinsics.areEqual((Object)this.annotationFqName, (Object)ExperimentalUsageChecker.Companion.getOLD_EXPERIMENTAL_FQ_NAME()) ^ true) {
                bl = !CompilerSettingsKt.getAdditionalArgumentsAsList((CompilerSettings)compilerSettings2).contains(this.compilerArgument);
            } else {
                Iterable $this$none$iv = CompilerSettingsKt.getAdditionalArgumentsAsList((CompilerSettings)compilerSettings2);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)"-Xopt-in=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-Xuse-experimental=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"-Xexperimental=", (boolean)false, (int)2, null))) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public MakeModuleExperimentalFix(@NotNull KtFile file, @NotNull Module module, @NotNull FqName annotationFqName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)annotationFqName, (String)"annotationFqName");
        super((PsiElement)file);
        this.module = module;
        this.annotationFqName = annotationFqName;
        ModuleDescriptor moduleDescriptor = MultiplatformUtilKt.toDescriptor((Module)this.module);
        this.experimentalPrefix = moduleDescriptor != null && ExperimentalFixesFactory.INSTANCE.fqNameIsExisting(moduleDescriptor, ExperimentalUsageChecker.Companion.getREQUIRES_OPT_IN_FQ_NAME()) ? "opt-in" : "use-experimental";
        this.compilerArgument = "-X" + this.experimentalPrefix + '=' + this.annotationFqName;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MakeModuleExperimentalFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            void it;
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiFile psiFile = psiElement2.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return null;
            }
            KtFile containingKtFile = ktFile;
            Module module = ProjectStructureUtilKt.getModule((PsiElement)containingKtFile);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            FqName fqName = ExperimentalUsageChecker.Companion.getREQUIRES_OPT_IN_FQ_NAME();
            boolean bl = false;
            boolean bl2 = false;
            FqName fqName2 = fqName;
            Module module3 = module2;
            KtFile ktFile2 = containingKtFile;
            boolean bl3 = false;
            ModuleDescriptor moduleDescriptor = MultiplatformUtilKt.toDescriptor((Module)module2);
            boolean bl4 = moduleDescriptor != null && ExperimentalFixesFactory.INSTANCE.fqNameIsExisting(moduleDescriptor, (FqName)it);
            Object object = bl4 ? fqName : null;
            if (object == null) {
                object = ExperimentalUsageChecker.Companion.getOLD_EXPERIMENTAL_FQ_NAME();
            }
            FqName fqName3 = object;
            Module module4 = module3;
            KtFile ktFile3 = ktFile2;
            return new MakeModuleExperimentalFix(ktFile3, module4, fqName3);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

