/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.kdoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/kdoc/KDocTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "handleBracketTyped", "", "overwriteClosingBracket", "kotlin.idea"})
public final class KDocTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (this.overwriteClosingBracket(c, editor2, file)) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.handleBracketTyped(c, project2, editor2, file) ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
    }

    private final boolean overwriteClosingBracket(char c, Editor editor2, PsiFile file) {
        if (c != ']' && c != ')') {
            return false;
        }
        if (!(file instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        CharSequence chars = charSequence;
        if (offset < document2.getTextLength() && chars.charAt(offset) == c) {
            boolean bl;
            Editor editor3 = editor2;
            if (editor3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            HighlighterIterator highlighterIterator = ((EditorEx)editor3).getHighlighter().createIterator(offset);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"(editor as EditorEx).hig\u2026er.createIterator(offset)");
            HighlighterIterator iterator = highlighterIterator;
            IElementType elementType = iterator.getTokenType();
            if (iterator.getStart() == 0) {
                return false;
            }
            iterator.retreat();
            IElementType prevElementType = iterator.getTokenType();
            switch (c) {
                case ']': {
                    if (KDocTokens.KDOC_HIGHLIGHT_TOKENS.contains(prevElementType) && (Intrinsics.areEqual((Object)elementType, (Object)KDocTokens.MARKDOWN_LINK) || offset > 0 && chars.charAt(offset - 1) == '[')) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case ')': {
                    bl = Intrinsics.areEqual((Object)elementType, (Object)KDocTokens.MARKDOWN_INLINE_LINK);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean handleBracketTyped(char c, Project project2, Editor editor2, PsiFile file) {
        if (c != '[' && c != '(') {
            return false;
        }
        if (!(file instanceof KtFile)) {
            return false;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        if (offset == 0) {
            return false;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiElement psiElement2 = file.findElementAt(offset - 1);
        if (psiElement2 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offset - 1) ?: return false");
        PsiElement element3 = psiElement2;
        ASTNode aSTNode = element3.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KDocTokens.TEXT) ^ true) {
            return false;
        }
        switch (c) {
            case '[': {
                document2.insertString(offset, (CharSequence)"]");
                return true;
            }
            case '(': {
                if (offset <= 1 || document2.getCharsSequence().charAt(offset - 2) != ']') break;
                document2.insertString(offset, (CharSequence)")");
                return true;
            }
        }
        return false;
    }
}

