/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.substring;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.substring.ReplaceSubstringInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/substring/ReplaceSubstringWithDropLastInspection;", "Lorg/jetbrains/kotlin/idea/inspections/substring/ReplaceSubstringInspection;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "isApplicableInner", "", "isLengthAccess", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedReceiver", "kotlin.idea"})
public final class ReplaceSubstringWithDropLastInspection
extends ReplaceSubstringInspection {
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("replace.substring.call.with.droplast.call", new Object[0]);
    }

    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.substring.call.with.droplast.call", new Object[0]);
    }

    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        KtBinaryExpression ktBinaryExpression;
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                object = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
                if (object == null || (object = object.getValueArguments()) == null) break block5;
                Object object2 = object;
                int n = 1;
                boolean bl = false;
                object = (KtValueArgument)CollectionsKt.getOrNull((List)object2, (int)n);
                if (object != null && (object = object.getArgumentExpression()) != null) break block6;
            }
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.callExpression?.\u2026entExpression() ?: return");
        Object argument2 = object;
        Object object3 = argument2;
        if (!(object3 instanceof KtBinaryExpression)) {
            object3 = null;
        }
        if ((ktBinaryExpression = (KtBinaryExpression)object3) == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktBinaryExpression, (String)"(argument as? KtBinaryExpression)?.right ?: return");
        KtBinaryExpression rightExpression = ktBinaryExpression;
        this.replaceWith(element3, "$0.dropLast($1)", (KtExpression)rightExpression);
    }

    @Override
    protected boolean isApplicableInner(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Object object = UtilsKt.getCallExpression((KtQualifiedExpression)element3);
        if (object == null || (object = object.getValueArguments()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element.callExpression?.\u2026Arguments ?: return false");
        Object arguments = object;
        if (arguments.size() != 2 || !this.isFirstArgumentZero(element3)) {
            return false;
        }
        KtExpression ktExpression = ((KtValueArgument)arguments.get(1)).getArgumentExpression();
        if (!(ktExpression instanceof KtBinaryExpression)) {
            ktExpression = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression secondArgumentExpression = ktBinaryExpression;
        if (Intrinsics.areEqual((Object)secondArgumentExpression.getOperationReference().getReferencedNameElementType(), (Object)KtTokens.MINUS) ^ true) {
            return false;
        }
        return this.isLengthAccess(secondArgumentExpression.getLeft(), element3.getReceiverExpression());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLengthAccess(KtExpression expression2, KtExpression expectedReceiver) {
        if (!(expression2 instanceof KtDotQualifiedExpression)) return false;
        KtExpression ktExpression = ((KtDotQualifiedExpression)expression2).getSelectorExpression();
        boolean bl = false;
        boolean bl2 = false;
        KtExpression it = ktExpression;
        boolean bl3 = false;
        if (!(it instanceof KtNameReferenceExpression)) return false;
        if (!Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getReferencedName(), (Object)"length")) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        if (!IfThenUtilsKt.evaluatesTo(((KtDotQualifiedExpression)expression2).getReceiverExpression(), expectedReceiver)) return false;
        return true;
    }
}

