/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslHighlighterExtension;
import org.jetbrains.kotlin.idea.highlighter.dsl.DslHighlighterExtensionKt;
import org.jetbrains.kotlin.idea.highlighter.markers.DslHighlightingMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.DslStyleIconKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\u0010\n\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\f0\u000bj\u0002`\r\u001a\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0010\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"navHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "toolTipHandler", "Lcom/intellij/util/Function;", "", "collectHighlightingColorsMarkers", "", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "styleIdForMarkerAnnotation", "", "(Lorg/jetbrains/kotlin/psi/KtClass;)Ljava/lang/Integer;", "kotlin.idea"})
public final class DslHighlightingMarkerKt {
    private static final GutterIconNavigationHandler<PsiElement> navHandler = navHandler.1.INSTANCE;
    private static final Function<PsiElement, String> toolTipHandler = toolTipHandler.1.INSTANCE;

    public static final void collectHighlightingColorsMarkers(@NotNull KtClass ktClass2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter((Object)ktClass2, (String)"ktClass");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!KotlinLineMarkerOptions.INSTANCE.getDslOption().isEnabled()) {
            return;
        }
        Integer n = DslHighlightingMarkerKt.styleIdForMarkerAnnotation(ktClass2);
        if (n == null) {
            return;
        }
        int styleId = n;
        PsiElement psiElement2 = ktClass2.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"ktClass.nameIdentifier ?: return");
        PsiElement anchor = psiElement2;
        result2.add(new LineMarkerInfo(anchor, anchor.getTextRange(), DslStyleIconKt.createDslStyleIcon(styleId), 11, toolTipHandler, navHandler, GutterIconRenderer.Alignment.RIGHT));
    }

    private static final Integer styleIdForMarkerAnnotation(KtClass $this$styleIdForMarkerAnnotation) {
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor((KtDeclaration)((KtDeclaration)$this$styleIdForMarkerAnnotation));
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        if (!DslHighlighterExtensionKt.isDslHighlightingMarker(classDescriptor2)) {
            return null;
        }
        return DslHighlighterExtension.Companion.styleIdByMarkerAnnotation(classDescriptor2);
    }

    public static final /* synthetic */ Integer access$styleIdForMarkerAnnotation(KtClass $this$access_u24styleIdForMarkerAnnotation) {
        return DslHighlightingMarkerKt.styleIdForMarkerAnnotation($this$access_u24styleIdForMarkerAnnotation);
    }
}

