/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinMissingIfBranchFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
public final class KotlinMissingIfBranchFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor2, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement element3) {
        boolean probablyNextStatementParsedAsThen;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!(element3 instanceof KtIfExpression)) {
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        KtExpression elseBranch = ((KtIfExpression)element3).getElse();
        PsiElement elseKeyword = ((KtIfExpression)element3).getElseKeyword();
        if (elseKeyword != null && (elseBranch == null || !(elseBranch instanceof KtBlockExpression) && FixersUtilKt.startLine((PsiElement)elseBranch, document2) > FixersUtilKt.startLine(elseKeyword, document2))) {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(elseKeyword)), (CharSequence)"{}");
            return;
        }
        KtExpression thenBranch = ((KtIfExpression)element3).getThen();
        if (thenBranch instanceof KtBlockExpression) {
            return;
        }
        PsiElement psiElement2 = ((KtIfExpression)element3).getRightParenthesis();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.rightParenthesis ?: return");
        PsiElement rParen = psiElement2;
        boolean transformingOneLiner = false;
        if (thenBranch != null && FixersUtilKt.startLine((PsiElement)thenBranch, document2) == FixersUtilKt.startLine(element3, document2)) {
            if (((KtIfExpression)element3).getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        boolean bl = probablyNextStatementParsedAsThen = elseKeyword == null && elseBranch == null && !transformingOneLiner;
        if (thenBranch == null || probablyNextStatementParsedAsThen) {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{}");
        } else {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{");
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)thenBranch)) + 1, (CharSequence)"}");
        }
    }
}

