/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.BaseDeclarationInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.KotlinCallableInsertHandler;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/handlers/BaseDeclarationInsertHandler;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "getCallType", "()Lorg/jetbrains/kotlin/idea/util/CallType;", "addImport", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "handleInsert", "Companion", "kotlin.idea"})
public abstract class KotlinCallableInsertHandler
extends BaseDeclarationInsertHandler {
    @NotNull
    private final CallType<?> callType;
    @NotNull
    private static final ShortenReferences SHORTEN_REFERENCES;
    public static final Companion Companion;

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        super.handleInsert(context2, item);
        this.addImport(context2, item);
    }

    private final void addImport(InsertionContext context2, LookupElement item) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)context2.getProject());
        psiDocumentManager.commitAllDocuments();
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"context.file");
        PsiFile file = psiFile;
        Object object = item.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.`object`");
        Object o = object;
        if (file instanceof KtFile && o instanceof DeclarationLookupObject) {
            DeclarationDescriptor declarationDescriptor = ((DeclarationLookupObject)o).getDescriptor();
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor descriptor2 = callableDescriptor;
            if (descriptor2.getExtensionReceiverParameter() != null || Intrinsics.areEqual(this.callType, (Object)CallType.CALLABLE_REFERENCE.INSTANCE)) {
                if (DescriptorUtils.isTopLevelDeclaration((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) && !CompletionUtilsKt.isArtificialImportAliasedDescriptor((DeclarationDescriptor)descriptor2)) {
                    Project project2 = context2.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
                    ImportInsertHelper.importDescriptor$default((ImportInsertHelper)ImportInsertHelper.Companion.getInstance(project2), (KtFile)((KtFile)file), (DeclarationDescriptor)((DeclarationDescriptor)descriptor2), (boolean)false, (int)4, null);
                }
            } else if (Intrinsics.areEqual(this.callType, (Object)CallType.DEFAULT.INSTANCE)) {
                if (CompletionUtilsKt.isArtificialImportAliasedDescriptor((DeclarationDescriptor)descriptor2)) {
                    return;
                }
                FqName fqName = ImportsUtils.getImportableFqName((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
                if (fqName == null) {
                    return;
                }
                FqName fqName2 = fqName;
                context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)(RenderingUtilsKt.render((FqName)UtilsKt.withRootPrefixIfNeeded$default((FqName)fqName2, null, (int)1, null)) + " "));
                psiDocumentManager.commitAllDocuments();
                CompletionUtilsKt.shortenReferences(context2, context2.getStartOffset(), context2.getTailOffset() - 1, SHORTEN_REFERENCES);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(context2.getDocument());
                Document document = context2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"context.document");
                if (HandlerUtilsKt.isTextAt(document, context2.getTailOffset() - 1, " ")) {
                    context2.getDocument().deleteString(context2.getTailOffset() - 1, context2.getTailOffset());
                }
            }
        }
    }

    @NotNull
    public final CallType<?> getCallType() {
        return this.callType;
    }

    public KotlinCallableInsertHandler(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        this.callType = callType;
    }

    static {
        Companion = new Companion(null);
        SHORTEN_REFERENCES = new ShortenReferences((Function1)Companion.SHORTEN_REFERENCES.1.INSTANCE);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/KotlinCallableInsertHandler$Companion;", "", "()V", "SHORTEN_REFERENCES", "Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "getSHORTEN_REFERENCES", "()Lorg/jetbrains/kotlin/idea/core/ShortenReferences;", "kotlin.idea"})
    public static final class Companion {
        @NotNull
        public final ShortenReferences getSHORTEN_REFERENCES() {
            return SHORTEN_REFERENCES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

