/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataInputStream;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.util.io.DigestUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u001a(\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"AES_CIPHER", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "FILE_VERSION_32", "", "FILE_VERSION_CRITICAL_MASK", "SIG1", "SIG2", "createProtectedStreamKey", "", "random", "Ljava/security/SecureRandom;", "getDecryptedInputStream", "Ljava/io/InputStream;", "encryptedInputStream", "keyData", "ivData", "getEncryptedOutputStream", "Ljava/io/OutputStream;", "decryptedOutputStream", "getFinalKeyDigest", "key", "masterSeed", "transformSeed", "transformRounds", "", "readHeaderData", "input", "Lcom/google/common/io/LittleEndianDataInputStream;", "readIntHeaderData", "readLongHeaderData", "readSignature", "", "verifyFileVersion", "intellij.platform.credentialStore"})
public final class KdbxHeaderKt {
    private static final UUID AES_CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");
    private static final int FILE_VERSION_CRITICAL_MASK = -65536;
    private static final int SIG1 = -1700603645;
    private static final int SIG2 = -1253311641;
    private static final int FILE_VERSION_32 = 196609;

    @NotNull
    public static final byte[] createProtectedStreamKey(@NotNull SecureRandom random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return CredentialStoreKt.generateBytes(random, 32);
    }

    private static final boolean readSignature(LittleEndianDataInputStream input) {
        return input.readInt() == -1700603645 && input.readInt() == -1253311641;
    }

    private static final boolean verifyFileVersion(LittleEndianDataInputStream input) {
        return (input.readInt() & 0xFFFF0000) <= 196608;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] getFinalKeyDigest(byte[] key, byte[] masterSeed, byte[] transformSeed, long transformRounds) {
        AESEngine engine = new AESEngine();
        engine.init(true, (CipherParameters)new KeyParameter(transformSeed));
        byte[] transformedKey = new byte[key.length];
        System.arraycopy(key, 0, transformedKey, 0, transformedKey.length);
        long l = 0L;
        long l2 = transformRounds;
        while (l < l2) {
            void rounds;
            engine.processBlock(transformedKey, 0, transformedKey, 0);
            engine.processBlock(transformedKey, 16, transformedKey, 16);
            ++rounds;
        }
        MessageDigest md = DigestUtil.sha256();
        byte[] transformedKeyDigest = md.digest(transformedKey);
        md.update(masterSeed);
        byte[] byArray = md.digest(transformedKeyDigest);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest(transformedKeyDigest)");
        return byArray;
    }

    private static final InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] keyData, byte[] ivData) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(false, (CipherParameters)keyAndIV);
        return (InputStream)new CipherInputStream(encryptedInputStream, (BufferedBlockCipher)cipher);
    }

    private static final OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] keyData, byte[] ivData) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(keyData), ivData));
        return (OutputStream)new CipherOutputStream(decryptedOutputStream, (BufferedBlockCipher)cipher);
    }

    private static final int readIntHeaderData(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 4) {
            throw (Throwable)new IllegalStateException("Int required but length was " + fieldLength);
        }
        return input.readInt();
    }

    private static final long readLongHeaderData(LittleEndianDataInputStream input) {
        short fieldLength = input.readShort();
        if (fieldLength != 8) {
            throw (Throwable)new IllegalStateException("Long required but length was " + fieldLength);
        }
        return input.readLong();
    }

    private static final byte[] readHeaderData(LittleEndianDataInputStream input) {
        byte[] value = new byte[input.readShort()];
        input.readFully(value);
        return value;
    }

    public static final /* synthetic */ byte[] access$getFinalKeyDigest(byte[] key, byte[] masterSeed, byte[] transformSeed, long transformRounds) {
        return KdbxHeaderKt.getFinalKeyDigest(key, masterSeed, transformSeed, transformRounds);
    }

    public static final /* synthetic */ InputStream access$getDecryptedInputStream(InputStream encryptedInputStream, byte[] keyData, byte[] ivData) {
        return KdbxHeaderKt.getDecryptedInputStream(encryptedInputStream, keyData, ivData);
    }

    public static final /* synthetic */ OutputStream access$getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] keyData, byte[] ivData) {
        return KdbxHeaderKt.getEncryptedOutputStream(decryptedOutputStream, keyData, ivData);
    }

    public static final /* synthetic */ UUID access$getAES_CIPHER$p() {
        return AES_CIPHER;
    }

    public static final /* synthetic */ boolean access$readSignature(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readSignature(input);
    }

    public static final /* synthetic */ boolean access$verifyFileVersion(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.verifyFileVersion(input);
    }

    public static final /* synthetic */ byte[] access$readHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readHeaderData(input);
    }

    public static final /* synthetic */ int access$readIntHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readIntHeaderData(input);
    }

    public static final /* synthetic */ long access$readLongHeaderData(LittleEndianDataInputStream input) {
        return KdbxHeaderKt.readLongHeaderData(input);
    }
}

