/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.EmptyNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingPropertyFix
implements LocalQuickFix,
BatchQuickFix<CommonProblemDescriptor> {
    private final JsonValidationError.MissingMultiplePropsIssueData myData;
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public AddMissingPropertyFix(JsonValidationError.MissingMultiplePropsIssueData data, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message("add.missing.properties", new Object[0]);
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = JsonBundle.message("add.missing.0", this.myData.getMessage(true));
        if (string == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        TextRange range;
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        Ref hadComma = Ref.create((Object)false);
        VirtualFile file = element.getContainingFile().getVirtualFile();
        PsiElement newElement = this.performFix(element, (Ref<Boolean>)hadComma);
        if (newElement == null) {
            return;
        }
        PsiElement value = this.myQuickFixAdapter.getPropertyValue(newElement);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
        assert (editor != null);
        if (value == null) {
            WriteAction.run(() -> editor.getCaretModel().moveToOffset(newElement.getTextRange().getEndOffset()));
            return;
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        TemplateBuilderImpl builder = new TemplateBuilderImpl(newElement);
        String text = value.getText();
        boolean isEmptyArray = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"[]");
        boolean isEmptyObject = StringUtil.equalsIgnoreWhitespaces((CharSequence)text, (CharSequence)"{}");
        boolean goInside = isEmptyArray || isEmptyObject || StringUtil.isQuotedString((String)text);
        TextRange textRange = range = goInside ? TextRange.create((int)1, (int)(text.length() - 1)) : TextRange.create((int)0, (int)text.length());
        builder.replaceElement(value, range, (Expression)(this.myData.myMissingPropertyIssues.iterator().next().enumItemsCount > 1 || isEmptyObject ? new MacroCallNode((Macro)new CompleteMacro()) : (isEmptyArray ? new EmptyNode() : new ConstantNode(goInside ? StringUtil.unquoteString((String)text) : text))));
        editor.getCaretModel().moveToOffset(newElement.getTextRange().getStartOffset());
        if (PsiTreeUtil.nextLeaf((PsiElement)newElement) != null) {
            builder.setEndVariableAfter(newElement);
        } else {
            builder.setEndVariableBefore(newElement.getLastChild());
        }
        WriteAction.run(() -> {
            Template template = builder.buildInlineTemplate();
            template.setToReformat(true);
            templateManager.startTemplate((Editor)editor, template);
        });
    }

    @Nullable
    public PsiElement performFix(@Nullable PsiElement node, @NotNull Ref<Boolean> hadComma) {
        if (hadComma == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(4);
        }
        if (node == null) {
            return null;
        }
        PsiElement element = node instanceof PsiFile ? node.getFirstChild() : node;
        Ref newElementRef = Ref.create(null);
        WriteAction.run(() -> {
            boolean isSingle = this.myData.myMissingPropertyIssues.size() == 1;
            PsiElement processedElement = element;
            List reverseOrder = ContainerUtil.reverse(new ArrayList<JsonValidationError.MissingPropertyIssueData>(this.myData.myMissingPropertyIssues));
            for (JsonValidationError.MissingPropertyIssueData issue : reverseOrder) {
                Object defaultValueObject = issue.defaultValue;
                String defaultValue = this.formatDefaultValue(defaultValueObject);
                PsiElement property = this.myQuickFixAdapter.createProperty(issue.propertyName, defaultValue == null ? this.myQuickFixAdapter.getDefaultValueFromType(issue.propertyType) : defaultValue, element);
                PsiElement newElement = processedElement instanceof LeafPsiElement ? this.myQuickFixAdapter.adjustPropertyAnchor((LeafPsiElement)processedElement).addBefore(property, null) : (processedElement == element ? processedElement.addBefore(property, processedElement.getLastChild()) : processedElement.getParent().addBefore(property, processedElement));
                PsiElement adjusted = this.myQuickFixAdapter.adjustNewProperty(newElement);
                hadComma.set((Object)this.myQuickFixAdapter.ensureComma(adjusted, PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)newElement)));
                if (!((Boolean)hadComma.get()).booleanValue()) {
                    hadComma.set((Object)(processedElement == element && this.myQuickFixAdapter.ensureComma(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)newElement), adjusted) ? 1 : 0));
                }
                processedElement = adjusted;
                if (!isSingle) continue;
                newElementRef.set((Object)adjusted);
            }
        });
        return (PsiElement)newElementRef.get();
    }

    @Nullable
    @Contract(value="null -> null")
    public String formatDefaultValue(@Nullable Object defaultValueObject) {
        if (defaultValueObject instanceof String) {
            return StringUtil.wrapWithDoubleQuote((String)defaultValueObject.toString());
        }
        if (defaultValueObject instanceof Boolean) {
            return Boolean.toString((Boolean)defaultValueObject);
        }
        if (defaultValueObject instanceof Number) {
            return defaultValueObject.toString();
        }
        if (defaultValueObject instanceof PsiElement) {
            return ((PsiElement)defaultValueObject).getText();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(5);
        }
        if (psiElementsToIgnore == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(7);
        }
        ArrayList<Pair> propFixes = new ArrayList<Pair>();
        for (CommonProblemDescriptor descriptor : descriptors) {
            AddMissingPropertyFix fix;
            QuickFix[] fixes;
            if (!(descriptor instanceof ProblemDescriptor) || (fixes = descriptor.getFixes()) == null || (fix = AddMissingPropertyFix.getWorkingQuickFix(fixes)) == null) continue;
            propFixes.add(Pair.create((Object)fix, (Object)((ProblemDescriptor)descriptor).getPsiElement()));
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> propFixes.forEach(fix -> ((AddMissingPropertyFix)fix.first).performFix((PsiElement)fix.second, (Ref<Boolean>)Ref.create((Object)false))));
    }

    @Nullable
    private static AddMissingPropertyFix getWorkingQuickFix(QuickFix @NotNull [] fixes) {
        if (fixes == null) {
            AddMissingPropertyFix.$$$reportNull$$$0(8);
        }
        for (QuickFix fix : fixes) {
            if (!(fix instanceof AddMissingPropertyFix)) continue;
            return (AddMissingPropertyFix)fix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hadComma";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/AddMissingPropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

