/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.jna.win;

import com.github.markusbernhardt.proxy.util.Logger;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.ptr.ByReference;

public class WTypes2 {
    private WTypes2() {
    }

    public static class LPWSTRByReference
    extends ByReference {
        public LPWSTRByReference() {
            super(Native.POINTER_SIZE);
            this.getPointer().setPointer(0L, null);
        }

        public WTypes.LPWSTR getValue() {
            Pointer p = this.getPointerToString();
            if (p == null) {
                return null;
            }
            WTypes.LPWSTR h = new WTypes.LPWSTR(p);
            return h;
        }

        public String getString() {
            return this.getValue() == null ? null : this.getValue().getValue();
        }

        private Pointer getPointerToString() {
            return this.getPointer().getPointer(0L);
        }

        protected void finalize() throws Throwable {
            try {
                Pointer result;
                Pointer strPointer = this.getPointerToString();
                if (strPointer != null && (result = Kernel32.INSTANCE.GlobalFree(strPointer)) != null) {
                    Logger.log(((Object)((Object)this)).getClass(), Logger.LogLevel.ERROR, "Windows function GlobalFree failed while freeing memory for {0} object", ((Object)((Object)this)).getClass().getSimpleName());
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

