/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.TextAttributesPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private static final TextAttributesKey GROUP_KEY;
    @NotNull
    private final IProperty myProperty;
    @NotNull
    private final BooleanSupplier myGrouped;
    private String myPresentableName;

    public PropertyStructureViewElement(@NotNull IProperty property, @NotNull BooleanSupplier grouped) {
        if (property == null) {
            PropertyStructureViewElement.$$$reportNull$$$0(0);
        }
        if (grouped == null) {
            PropertyStructureViewElement.$$$reportNull$$$0(1);
        }
        this.myProperty = property;
        this.myGrouped = grouped;
    }

    @Nullable
    public IProperty getProperty() {
        return this.getPsiElement() != null ? this.myProperty : null;
    }

    @Nullable
    public PsiElement getPsiElement() {
        PsiElement element = this.myProperty.getPsiElement();
        return element.isValid() ? element : null;
    }

    @Override
    @NotNull
    public IProperty[] getProperties() {
        IProperty[] iPropertyArray = new IProperty[]{this.myProperty};
        if (iPropertyArray == null) {
            PropertyStructureViewElement.$$$reportNull$$$0(2);
        }
        return iPropertyArray;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        return null;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    private String getPresentableName() {
        return this.myGrouped.getAsBoolean() ? this.myPresentableName : null;
    }

    public IProperty getValue() {
        return this.getProperty();
    }

    public StructureViewTreeElement @NotNull [] getChildren() {
        if (EMPTY_ARRAY == null) {
            PropertyStructureViewElement.$$$reportNull$$$0(3);
        }
        return EMPTY_ARRAY;
    }

    protected TextAttributes getErrorTextAttributes(EditorColorsScheme colorsScheme) {
        return null;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new TextAttributesPresentation(){

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return PropertyStructureViewElement.this.getPresentableName() != null && PropertyStructureViewElement.this.getPresentableName().isEmpty() ? GROUP_KEY : null;
            }

            public String getPresentableText() {
                IProperty property = PropertyStructureViewElement.this.getProperty();
                if (property == null) {
                    return null;
                }
                String presentableName = PropertyStructureViewElement.this.getPresentableName();
                if (presentableName == null) {
                    return property.getName();
                }
                return !presentableName.isEmpty() ? presentableName : PropertiesBundle.message("structure.view.empty.property.presentation", new Object[0]);
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return PropertyStructureViewElement.this.myProperty.getIcon(0);
            }

            @Override
            public TextAttributes getTextAttributes(EditorColorsScheme colorsScheme) {
                TextAttributes highlightingAttributes;
                TextAttributesKey baseAttrKey = PropertyStructureViewElement.this.getPresentableName() != null && PropertyStructureViewElement.this.getPresentableName().isEmpty() ? GROUP_KEY : PropertiesHighlighter.PROPERTY_KEY;
                TextAttributes baseAttrs = colorsScheme.getAttributes(baseAttrKey);
                if (PropertyStructureViewElement.this.getPsiElement() != null && (highlightingAttributes = PropertyStructureViewElement.this.getErrorTextAttributes(colorsScheme)) != null) {
                    return TextAttributes.merge((TextAttributes)baseAttrs, (TextAttributes)highlightingAttributes);
                }
                return baseAttrs;
            }
        };
    }

    public void navigate(boolean requestFocus) {
        this.myProperty.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myProperty.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myProperty.canNavigateToSource();
    }

    static {
        TextAttributes groupKeyTextAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_KEY).clone();
        groupKeyTextAttributes.setFontType(2);
        GROUP_KEY = TextAttributesKey.createTextAttributesKey((String)"GROUP_KEY", (TextAttributes)groupKeyTextAttributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/PropertyStructureViewElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/PropertyStructureViewElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

