/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof IProperty) {
            return "\"" + PropertiesDocumentationProvider.renderPropertyValue((IProperty)element) + "\"" + PropertiesDocumentationProvider.getLocationString(element);
        }
        return null;
    }

    private static String getLocationString(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null ? " [" + file.getName() + "]" : "";
    }

    @NotNull
    private static String renderPropertyValue(IProperty prop) {
        String raw = prop.getValue();
        if (raw == null) {
            return "<i>empty</i>";
        }
        String string = StringUtil.escapeXmlEntities((String)raw);
        if (string == null) {
            PropertiesDocumentationProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof IProperty) {
            IProperty property = (IProperty)element;
            String text = property.getDocCommentText();
            @NonNls Object info = "";
            if (text != null) {
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_COMMENT).clone();
                Color background = attributes.getBackgroundColor();
                if (background != null) {
                    info = (String)info + "<div bgcolor=#" + GuiUtils.colorToHex((Color)background) + ">";
                }
                String doc = StringUtil.join((Collection)ContainerUtil.map((Collection)StringUtil.split((String)text, (String)"\n"), s -> {
                    String trimHash = StringUtil.trimStart((String)s, (String)"#");
                    String trimExclamation = StringUtil.trimStart((String)trimHash, (String)"!");
                    return trimExclamation.trim();
                }), (String)"<br>");
                Color foreground = attributes.getForegroundColor();
                info = (String)info + (String)(foreground != null ? "<font color=#" + GuiUtils.colorToHex((Color)foreground) + ">" + doc + "</font>" : doc);
                info = (String)info + "\n<br>";
                if (background != null) {
                    info = (String)info + "</div>";
                }
            }
            info = (String)info + "\n<b>" + property.getName() + "</b>=\"" + PropertiesDocumentationProvider.renderPropertyValue((IProperty)element) + "\"";
            info = (String)info + PropertiesDocumentationProvider.getLocationString(element);
            return info;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/PropertiesDocumentationProvider", "renderPropertyValue"));
    }
}

