/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.defaults.AssignabilityRegistrationException;

public abstract class AbstractComponentAdapter
implements ComponentAdapter {
    private final Object componentKey;
    private final Class<?> componentImplementation;

    protected AbstractComponentAdapter(Object componentKey, Class<?> componentImplementation) {
        Class componentType;
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        if (componentKey instanceof Class && !(componentType = (Class)componentKey).isAssignableFrom(componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, componentImplementation);
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
    }

    @Override
    public final Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    @Override
    public final Class<?> getComponentImplementation() {
        return this.componentImplementation;
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.getComponentKey() + "]";
    }
}

