/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.util.TestNGUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConvertOldAnnotationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "ConvertOldAnnotations";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ConvertOldAnnotationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                String qualifiedName = annotation.getQualifiedName();
                if (Comparing.strEqual((String)qualifiedName, (String)"org.testng.annotations.Configuration")) {
                    holder.registerProblem((PsiElement)annotation, TestngBundle.message("inspection.message.old.testng.annotation.configuration.used", new Object[0]), new LocalQuickFix[]{new ConvertOldAnnotationsQuickfix()});
                }
            }
        };
    }

    private static void convertOldAnnotationAttributeToAnnotation(PsiModifierList modifierList, PsiAnnotation annotation, @NonNls String attribute, @NonNls String newAnnotation) throws IncorrectOperationException {
        PsiAnnotationParameterList list = annotation.getParameterList();
        Project project = annotation.getProject();
        for (PsiNameValuePair pair : list.getAttributes()) {
            if (!attribute.equals(pair.getName())) continue;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation newPsiAnnotation = factory.createAnnotationFromText(newAnnotation + "()", (PsiElement)modifierList);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(modifierList.addAfter((PsiElement)newPsiAnnotation, null));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/ConvertOldAnnotationInspection", "buildVisitor"));
    }

    private static class ConvertOldAnnotationsQuickfix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(ConvertOldAnnotationsQuickfix.class);

        private ConvertOldAnnotationsQuickfix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = TestngBundle.message("intention.family.name.convert.old.configuration.testng.annotations", new Object[0]);
            if (string == null) {
                ConvertOldAnnotationsQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiAnnotation annotation;
            if (project == null) {
                ConvertOldAnnotationsQuickfix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertOldAnnotationsQuickfix.$$$reportNull$$$0(2);
            }
            if (!TestNGUtil.checkTestNGInClasspath((PsiElement)(annotation = (PsiAnnotation)descriptor.getPsiElement()))) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{annotation})) {
                return;
            }
            WriteAction.run(() -> ConvertOldAnnotationsQuickfix.doFix(annotation));
        }

        private static void doFix(PsiAnnotation annotation) {
            PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierList.class);
            LOG.assertTrue(modifierList != null);
            try {
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTest", "@org.testng.annotations.BeforeTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTestClass", "@org.testng.annotations.BeforeTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeTestMethod", "@org.testng.annotations.BeforeMethod");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeSuite", "@org.testng.annotations.BeforeSuite");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "beforeGroups", "@org.testng.annotations.BeforeGroups");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTest", "@org.testng.annotations.AfterTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTestClass", "@org.testng.annotations.AfterTest");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterTestMethod", "@org.testng.annotations.AfterMethod");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterSuite", "@org.testng.annotations.AfterSuite");
                ConvertOldAnnotationInspection.convertOldAnnotationAttributeToAnnotation(modifierList, annotation, "afterGroups", "@org.testng.annotations.AfterGroups");
                annotation.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/ConvertOldAnnotationInspection$ConvertOldAnnotationsQuickfix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/ConvertOldAnnotationInspection$ConvertOldAnnotationsQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

