/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class Node {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Url myUrl;
    @NotNull
    private final Url myRepositoryUrl;
    @Nullable
    private final SvnBindException myError;

    public Node(@NotNull VirtualFile file, @NotNull Url url, @NotNull Url repositoryUrl) {
        if (file == null) {
            Node.$$$reportNull$$$0(0);
        }
        if (url == null) {
            Node.$$$reportNull$$$0(1);
        }
        if (repositoryUrl == null) {
            Node.$$$reportNull$$$0(2);
        }
        this(file, url, repositoryUrl, null);
    }

    public Node(@NotNull VirtualFile file, @NotNull Url url, @NotNull Url repositoryUrl, @Nullable SvnBindException error) {
        if (file == null) {
            Node.$$$reportNull$$$0(3);
        }
        if (url == null) {
            Node.$$$reportNull$$$0(4);
        }
        if (repositoryUrl == null) {
            Node.$$$reportNull$$$0(5);
        }
        this.myFile = file;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myError = error;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            Node.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public File getIoFile() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile());
        if (file == null) {
            Node.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public Url getUrl() {
        Url url = this.myUrl;
        if (url == null) {
            Node.$$$reportNull$$$0(8);
        }
        return url;
    }

    @NotNull
    public Url getRepositoryRootUrl() {
        Url url = this.myRepositoryUrl;
        if (url == null) {
            Node.$$$reportNull$$$0(9);
        }
        return url;
    }

    @Nullable
    public SvnBindException getError() {
        return this.myError;
    }

    public boolean hasError() {
        return this.myError != null;
    }

    public boolean onUrl(@Nullable Url url) {
        return this.myUrl.equals(url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (this.myError != null ? node.myError == null || !this.myError.getMessage().equals(node.myError.getMessage()) : node.myError != null) {
            return false;
        }
        if (!this.myFile.equals(node.myFile)) {
            return false;
        }
        if (!this.myRepositoryUrl.equals(node.myRepositoryUrl)) {
            return false;
        }
        return this.myUrl.equals(node.myUrl);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myRepositoryUrl.hashCode();
        result = 31 * result + (this.myError != null ? this.myError.getMessage().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/Node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/Node";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIoFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryRootUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

