/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FilePredictionHistoryState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryPersistence;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getPathToStorage", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "loadFileHistory", "Lcom/intellij/filePrediction/features/history/FilePredictionHistoryState;", "saveFileHistory", "", "state", "intellij.filePrediction"})
public final class FileHistoryPersistence {
    private static final Logger LOG;
    public static final FileHistoryPersistence INSTANCE;

    public final void saveFileHistory(@NotNull Project project, @NotNull FilePredictionHistoryState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Path path = this.getPathToStorage(project);
        try {
            if (path != null) {
                JDOMUtil.write((Element)state.serialize(), (Path)path);
            }
        }
        catch (IOException e) {
            LOG.warn("Cannot serialize opened files history", (Throwable)e);
        }
    }

    @NotNull
    public final FilePredictionHistoryState loadFileHistory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FilePredictionHistoryState state = new FilePredictionHistoryState();
        if (project.isDisposed()) {
            return state;
        }
        Path path = this.getPathToStorage(project);
        try {
            if (path != null && PathKt.exists((Path)path)) {
                Element element = JDOMUtil.load((Path)path);
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"JDOMUtil.load(path)");
                state.deserialize(element);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize opened files history", (Throwable)e);
        }
        return state;
    }

    private final Path getPathToStorage(Project project) {
        Path projectPath;
        String string = project.getPresentableUrl();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.presentableUrl ?: return null");
        String url = string;
        Path path = projectPath = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectPath");
        Object object = path.getFileName();
        if (object == null || (object = object.toString()) == null) {
            String string2 = ((Object)projectPath).toString();
            int n = 0;
            int n2 = 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        Object dirName = object;
        String string5 = PathUtil.suggestFileName((String)((String)dirName + Integer.toHexString(((Object)projectPath).toString().hashCode())));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"PathUtil.suggestFileName\u2026h.toString().hashCode()))");
        String storageName = string5;
        return Paths.get(PathManager.getSystemPath(), "fileHistory", storageName + ".xml");
    }

    private FileHistoryPersistence() {
    }

    static {
        FileHistoryPersistence fileHistoryPersistence;
        INSTANCE = fileHistoryPersistence = new FileHistoryPersistence();
        Logger logger = Logger.getInstance(FileHistoryPersistence.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileH\u2026yPersistence::class.java)");
        LOG = logger;
    }
}

