/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.util.lang.JavaVersion;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleJvmProviderId;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionContext;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;
import org.jetbrains.plugins.gradle.util.GradleProperties;
import org.jetbrains.plugins.gradle.util.GradlePropertiesUtil;
import org.jetbrains.plugins.gradle.util.JavaHomeValidationStatus;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0018H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0017*\u00020\u0018H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\u0018H\u0002\u00a8\u0006\u001c"}, d2={"findGradleVersion", "Lorg/gradle/util/GradleVersion;", "project", "Lcom/intellij/openapi/project/Project;", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "getGradleJvmLookupProvider", "Lcom/intellij/openapi/roots/ui/configuration/SdkLookupProvider;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "resolveProjectJdk", "setupGradleJvm", "", "gradleVersion", "suggestGradleVersion", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "suggestOldestCompatibleGradleVersion", "updateGradleJvm", "externalProjectPath", "", "canUseGradleJavaHomeJdk", "", "Lorg/jetbrains/plugins/gradle/util/GradleJvmResolutionContext;", "canUseJavaHomeJdk", "canUseProjectSdk", "findGradleJvm", "intellij.gradle.common"})
@JvmName(name="GradleJvmResolutionUtil")
@ApiStatus.Internal
public final class GradleJvmResolutionUtil {
    @NotNull
    public static final SdkLookupProvider getGradleJvmLookupProvider(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        return SdkLookupProvider.Companion.getInstance(project, (SdkLookupProvider.Id)new GradleJvmProviderId(projectSettings));
    }

    public static final void setupGradleJvm(@NotNull Project project, @NotNull GradleProjectSettings projectSettings, @NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        Path path = Paths.get(projectSettings.getExternalProjectPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(projectSettings.externalProjectPath)");
        GradleJvmResolutionContext resolutionContext = new GradleJvmResolutionContext(project, path, gradleVersion);
        projectSettings.setGradleJvm(GradleJvmResolutionUtil.findGradleJvm(resolutionContext));
        if (projectSettings.getGradleJvm() != null) {
            return;
        }
        if (GradleJvmResolutionUtil.canUseProjectSdk(resolutionContext)) {
            projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        } else if (GradleJvmResolutionUtil.canUseGradleJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#GRADLE_JAVA_HOME");
        } else if (GradleJvmResolutionUtil.canUseJavaHomeJdk(resolutionContext)) {
            projectSettings.setGradleJvm("#JAVA_HOME");
        } else {
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project, projectSettings).newLookupBuilder().withVersionFilter((Function1)new Function1<String, Boolean>(gradleVersion){
                final /* synthetic */ GradleVersion $gradleVersion;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return GradleJvmValidationUtil.isSupported(this.$gradleVersion, it);
                }
                {
                    this.$gradleVersion = gradleVersion;
                    super(1);
                }
            });
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"ExternalSystemJdkUtil.getJavaSdkType()");
            sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter((Function1)setupGradleJvm.2.INSTANCE).onSdkNameResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;

                public final void invoke(@Nullable Sdk sdk) {
                    Sdk fakeSdk;
                    Sdk sdk2;
                    Sdk sdk3 = sdk;
                    if (sdk3 != null) {
                        Sdk sdk4 = sdk3;
                        boolean bl = false;
                        boolean bl2 = false;
                        Sdk p1 = sdk4;
                        boolean bl3 = false;
                        sdk2 = GradleJvmResolutionUtil.access$findRegisteredSdk(p1);
                    } else {
                        sdk2 = fakeSdk = null;
                    }
                    if (fakeSdk != null && this.$projectSettings.getGradleJvm() == null) {
                        this.$projectSettings.setGradleJvm(fakeSdk.getName());
                    }
                }
                {
                    this.$projectSettings = gradleProjectSettings;
                    super(1);
                }
            }).onSdkResolved((Function1)new Function1<Sdk, Unit>(projectSettings){
                final /* synthetic */ GradleProjectSettings $projectSettings;

                public final void invoke(@Nullable Sdk sdk) {
                    if (this.$projectSettings.getGradleJvm() == null) {
                        Sdk sdk2 = sdk;
                        this.$projectSettings.setGradleJvm(sdk2 != null ? sdk2.getName() : null);
                    }
                }
                {
                    this.$projectSettings = gradleProjectSettings;
                    super(1);
                }
            }).executeLookup();
        }
    }

    public static final void updateGradleJvm(@NotNull Project project, @NotNull String externalProjectPath) {
        ProjectRootManager projectRootManager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(externalProjectPath);
        if (gradleProjectSettings == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleProjectSettings), (String)"settings.getLinkedProjec\u2026nalProjectPath) ?: return");
        GradleProjectSettings projectSettings = gradleProjectSettings;
        String string = projectSettings.getGradleJvm();
        if (string == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectSettings.gradleJvm ?: return");
        String gradleJvm = string;
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager2, (String)"projectRootManager");
        Sdk sdk = projectRootManager2.getProjectSdk();
        if (sdk == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"projectRootManager.projectSdk ?: return");
        Sdk projectSdk = sdk;
        if (Intrinsics.areEqual((Object)projectSdk.getName(), (Object)gradleJvm) ^ true) {
            return;
        }
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
    }

    @Nullable
    public static final GradleVersion suggestGradleVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GradleVersion gradleVersion = GradleJvmResolutionUtil.findGradleVersion(project);
        if (gradleVersion != null) {
            return gradleVersion;
        }
        Sdk sdk = GradleJvmResolutionUtil.resolveProjectJdk(project);
        if (sdk == null) {
            return null;
        }
        Sdk projectJdk = sdk;
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)projectJdk)) {
            return null;
        }
        JavaVersion javaVersion = JavaVersion.tryParse((String)projectJdk.getVersionString());
        if (javaVersion == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"JavaVersion.tryParse(pro\u2026ionString) ?: return null");
        JavaVersion javaVersion2 = javaVersion;
        return GradleJvmResolutionUtil.suggestGradleVersion(javaVersion2);
    }

    @Nullable
    public static final GradleVersion suggestGradleVersion(@NotNull JavaVersion javaVersion) {
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"GradleVersion.current()");
        return GradleJvmValidationUtil.isSupported(gradleVersion, javaVersion) ? GradleVersion.current() : (javaVersion.feature >= 8 ? GradleVersion.version((String)"6.7") : (javaVersion.feature == 7 ? GradleVersion.version((String)"4.10.3") : null));
    }

    @Nullable
    public static final GradleVersion suggestOldestCompatibleGradleVersion(@NotNull JavaVersion javaVersion) {
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        return javaVersion.feature >= 15 ? GradleVersion.version((String)"6.7") : (javaVersion.feature >= 11 ? GradleVersion.version((String)"4.8") : (javaVersion.feature >= 7 ? GradleVersion.version((String)"3.0") : null));
    }

    private static final GradleVersion findGradleVersion(Project project) {
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"settings.linkedProjectsSettings");
        return (GradleVersion)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)findGradleVersion.1.INSTANCE));
    }

    private static final boolean canUseGradleJavaHomeJdk(GradleJvmResolutionContext $this$canUseGradleJavaHomeJdk) {
        GradleProperties properties = GradlePropertiesUtil.getGradleProperties($this$canUseGradleJavaHomeJdk.getExternalProjectPath());
        GradleProperties.GradleProperty<String> gradleProperty = properties.getJavaHomeProperty();
        String javaHome = gradleProperty != null ? gradleProperty.getValue() : null;
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseGradleJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final boolean canUseJavaHomeJdk(GradleJvmResolutionContext $this$canUseJavaHomeJdk) {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        JavaHomeValidationStatus validationStatus = GradleJvmValidationUtil.validateGradleJavaHome($this$canUseJavaHomeJdk.getGradleVersion(), javaHome);
        return validationStatus instanceof JavaHomeValidationStatus.Success;
    }

    private static final String findGradleJvm(GradleJvmResolutionContext $this$findGradleJvm) {
        GradleSettings gradleSettings = GradleSettings.getInstance($this$findGradleJvm.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        Collection collection = settings2.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"settings.linkedProjectsSettings");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)findGradleJvm.1.INSTANCE));
    }

    private static final boolean canUseProjectSdk(GradleJvmResolutionContext $this$canUseProjectSdk) {
        Sdk sdk = GradleJvmResolutionUtil.resolveProjectJdk($this$canUseProjectSdk.getProject());
        if (sdk == null) {
            return false;
        }
        Sdk projectJdk = sdk;
        if (!ExternalSystemJdkUtil.isValidJdk((Sdk)projectJdk)) {
            return false;
        }
        String string = projectJdk.getVersionString();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectJdk.versionString ?: return false");
        String versionString = string;
        return GradleJvmValidationUtil.isSupported($this$canUseProjectSdk.getGradleVersion(), versionString);
    }

    private static final Sdk resolveProjectJdk(Project project) {
        ProjectRootManager projectRootManager;
        ProjectRootManager projectRootManager2 = projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager2, (String)"projectRootManager");
        Sdk sdk = projectRootManager2.getProjectSdk();
        if (sdk == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"projectRootManager.projectSdk ?: return null");
        Sdk projectSdk = sdk;
        return ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
    }

    private static final Sdk findRegisteredSdk(Sdk sdk) {
        boolean $i$f$runReadAction = false;
        return (Sdk)ApplicationManager.getApplication().runReadAction(new Computable<T>(sdk){
            final /* synthetic */ Sdk $sdk$inlined;
            {
                this.$sdk$inlined = sdk;
            }

            public final T compute() {
                boolean bl = false;
                ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
                String string = this.$sdk$inlined.getName();
                SdkTypeId sdkTypeId = this.$sdk$inlined.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"sdk.sdkType");
                return (T)projectJdkTable.findJdk(string, sdkTypeId.getName());
            }
        });
    }

    public static final /* synthetic */ Sdk access$findRegisteredSdk(Sdk sdk) {
        return GradleJvmResolutionUtil.findRegisteredSdk(sdk);
    }
}

