/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class DomFileMetaData
extends AbstractExtensionPointBean {
    static final ExtensionPointName<DomFileMetaData> EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileMetaData");
    @Attribute(value="implementation")
    @RequiredElement
    public String implementation;
    @Attribute(value="rootTagName")
    @Nullable
    public String rootTagName;
    @Attribute(value="domVersion")
    public int domVersion;
    @Attribute(value="stubVersion")
    @Nullable
    public Integer stubVersion;
    volatile DomFileDescription<?> lazyInstance;

    public DomFileMetaData() {
    }

    public DomFileMetaData(DomFileDescription<?> description) {
        this.lazyInstance = description;
        this.implementation = description.getClass().getName();
        this.rootTagName = description.acceptsOtherRootTagNames() ? null : description.getRootTagName();
        this.domVersion = description.getVersion();
        this.stubVersion = description.hasStubs() ? Integer.valueOf(description.getStubVersion()) : null;
    }

    DomFileDescription<?> getDescription() {
        DomFileDescription instance = this.lazyInstance;
        if (instance == null) {
            try {
                instance = (DomFileDescription)DomFileMetaData.instantiate((Class)this.findExtensionClass(this.implementation), (PicoContainer)ApplicationManager.getApplication().getPicoContainer());
                if (StringUtil.isEmpty((String)this.rootTagName)) {
                    if (!instance.acceptsOtherRootTagNames()) {
                        throw new PluginException(this.implementation + " should either specify 'rootTagName' in XML, or return true from 'acceptsOtherRootTagNames'", this.getPluginId());
                    }
                } else if (!this.rootTagName.equals(instance.getRootTagName())) {
                    throw new PluginException(this.implementation + " XML declaration should have '" + instance.getRootTagName() + "' for 'rootTagName'", this.getPluginId());
                }
                DomApplicationComponent.getInstance().initDescription(instance);
                this.lazyInstance = instance;
            }
            catch (PluginException | ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PluginException((Throwable)e, this.getPluginId());
            }
        }
        return instance;
    }

    public boolean hasStubs() {
        return this.stubVersion != null;
    }
}

