/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.model.idea.IdeaDependencyScope;

public final class InternalIdeaDependencyScope
implements IdeaDependencyScope {
    private static final Map<String, InternalIdeaDependencyScope> SCOPES_MAP = new HashMap<String, InternalIdeaDependencyScope>();
    private final String myScope;

    public InternalIdeaDependencyScope(String scope) {
        this.myScope = scope;
    }

    public String getScope() {
        return this.myScope;
    }

    public String toString() {
        return "IdeaDependencyScope{myScope='" + this.myScope + '\'' + '}';
    }

    public static InternalIdeaDependencyScope getInstance(String scope) {
        InternalIdeaDependencyScope dependencyScope = SCOPES_MAP.get(scope == null || scope.isEmpty() ? "Compile" : scope);
        return dependencyScope == null ? new InternalIdeaDependencyScope(scope) : dependencyScope;
    }

    static {
        SCOPES_MAP.put("Compile", new InternalIdeaDependencyScope("Compile"));
        SCOPES_MAP.put("Test", new InternalIdeaDependencyScope("Test"));
        SCOPES_MAP.put("Runtime", new InternalIdeaDependencyScope("Runtime"));
        SCOPES_MAP.put("Provided", new InternalIdeaDependencyScope("Provided"));
    }
}

