/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.util.Optional;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public interface AtomicType
extends SimpleType,
PlainType {
    @Override
    default public Genre getGenre() {
        return Genre.ATOMIC;
    }

    public ValidationFailure validate(AtomicValue var1, CharSequence var2, ConversionRules var3);

    public boolean isOrdered(boolean var1);

    public boolean isAbstract();

    public boolean isPrimitiveType();

    @Override
    public boolean isBuiltInType();

    @Override
    public StructuredQName getTypeName();

    public StringConverter getStringConverter(ConversionRules var1);

    @Override
    default public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        if (item instanceof AtomicValue) {
            return Optional.of("The supplied value is of type " + ((AtomicValue)item).getItemType());
        }
        return Optional.of("The supplied value is " + item.getGenre().getDescription());
    }
}

