/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.testFramework.HeavyTestHelper;
import com.intellij.testFramework.OpenProjectTaskBuilderKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TemporaryDirectory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0007J,\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J2\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0007\u00a8\u0006%"}, d2={"Lcom/intellij/testFramework/HeavyTestHelper;", "", "()V", "createChildDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "dir", "name", "", "createModuleAt", "Lcom/intellij/openapi/module/Module;", "moduleName", "project", "Lcom/intellij/openapi/project/Project;", "moduleType", "Lcom/intellij/openapi/module/ModuleType;", "path", "Ljava/nio/file/Path;", "createTempDirectoryForTempDirTestFixture", "prefix", "createTestProjectStructure", "module", "rootPath", "addProjectRoots", "", "createVirtualFileWithEncodingUsingNio", "ext", "bom", "", "content", "charset", "Ljava/nio/charset/Charset;", "temporaryDirectory", "Lcom/intellij/testFramework/TemporaryDirectory;", "getOrCreateProjectBaseDir", "openHeavyTestFixtureProject", "moduleListener", "Lcom/intellij/openapi/project/ModuleListener;", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class HeavyTestHelper {
    public static final HeavyTestHelper INSTANCE;

    @JvmStatic
    @NotNull
    public static final Project openHeavyTestFixtureProject(@NotNull Path path, @NotNull ModuleListener moduleListener) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)moduleListener, (String)"moduleListener");
        OpenProjectTask options2 = OpenProjectTask.copy$default((OpenProjectTask)OpenProjectTaskBuilderKt.createTestOpenProjectOptions$default(false, 1, null), (boolean)false, null, (boolean)false, (boolean)false, null, null, (boolean)false, null, null, (int)0, (int)0, (boolean)false, (boolean)false, (boolean)false, null, (boolean)false, (boolean)false, null, (Function1)((Function1)new Function1<Project, Boolean>(moduleListener){
            final /* synthetic */ ModuleListener $moduleListener;

            public final boolean invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getMessageBus().simpleConnect().subscribe(ProjectTopics.MODULES, (Object)this.$moduleListener);
                return true;
            }
            {
                this.$moduleListener = moduleListener;
                super(1);
            }
        }), null, (int)786431, null);
        Project project2 = ProjectManagerEx.getInstanceEx().openProject(path, options2);
        Intrinsics.checkNotNull((Object)project2);
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"ProjectManagerEx.getInst\u2026nProject(path, options)!!");
        Project project3 = project2;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            PlatformTestUtil.dispatchAllInvocationEventsInIdeEventQueue();
        }
        return project3;
    }

    @JvmStatic
    @NotNull
    public static final Module createModuleAt(@NotNull String moduleName, @NotNull Project project2, @NotNull ModuleType<?> moduleType, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(moduleType, (String)"moduleType");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path moduleFile = path.resolve(moduleName + ".iml");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Object object = WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Module, Throwable>(moduleManager, moduleFile, moduleType){
            final /* synthetic */ ModuleManager $moduleManager;
            final /* synthetic */ Path $moduleFile;
            final /* synthetic */ ModuleType $moduleType;

            public final Module compute() {
                return this.$moduleManager.newModule(this.$moduleFile, this.$moduleType.getId());
            }
            {
                this.$moduleManager = moduleManager;
                this.$moduleFile = path;
                this.$moduleType = moduleType;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.computeAndWa\u2026ile, moduleType.id)\n    }");
        return (Module)object;
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile createTestProjectStructure(@Nullable Module module, @Nullable String rootPath, @NotNull Path dir, boolean addProjectRoots) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(dir);
        if (virtualFile == null) {
            throw (Throwable)new IllegalStateException("Cannot find virtual directory by " + dir);
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026rtual directory by $dir\")");
        VirtualFile virtualDir = virtualFile;
        virtualDir.getChildren();
        virtualDir.refresh(false, true);
        WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<Unit, IOException>(rootPath, virtualDir, addProjectRoots, module){
            final /* synthetic */ String $rootPath;
            final /* synthetic */ VirtualFile $virtualDir;
            final /* synthetic */ boolean $addProjectRoots;
            final /* synthetic */ Module $module;

            public final void compute() {
                if (this.$rootPath != null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(StringsKt.replace$default((String)this.$rootPath, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
                    if (virtualFile == null) {
                        throw (Throwable)new Exception(this.$rootPath + " not found");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026on(\"$rootPath not found\")");
                    VirtualFile vDir1 = virtualFile;
                    VfsUtil.copyDirectory(null, (VirtualFile)vDir1, (VirtualFile)this.$virtualDir, null);
                }
                if (this.$addProjectRoots) {
                    Module module = this.$module;
                    Intrinsics.checkNotNull((Object)module);
                    ModuleRootModificationUtil.modifyModel((Module)module, (Function)new Function<ModifiableRootModel, Boolean>(this){
                        final /* synthetic */ createTestProjectStructure.1 this$0;

                        public final Boolean apply(ModifiableRootModel model) {
                            model.addContentEntry(this.this$0.$virtualDir).addSourceFolder(this.this$0.$virtualDir, false);
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.$rootPath = string;
                this.$virtualDir = virtualFile;
                this.$addProjectRoots = bl;
                this.$module = module;
            }
        }));
        return virtualDir;
    }

    @JvmStatic
    @NotNull
    public static final Path createTempDirectoryForTempDirTestFixture(@Nullable Path dir, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path = dir;
        if (path == null) {
            path = Paths.get(FileUtil.getTempDirectory(), new String[0]);
        }
        Path parentDir = path;
        Files.createDirectories(parentDir, new FileAttribute[0]);
        Path path2 = Files.createTempDirectory(parentDir, prefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Files.createTempDirectory(parentDir, prefix)");
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile getOrCreateProjectBaseDir(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path = ProjectKt.getStateStore((Project)project2).getProjectBasePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.stateStore.getProjectBasePath()");
        Path basePath = path;
        LocalFileSystem fs = LocalFileSystem.getInstance();
        VirtualFile baseDir = fs.findFileByNioFile(basePath);
        if (baseDir == null) {
            Files.createDirectories(basePath, new FileAttribute[0]);
            VirtualFile virtualFile = fs.refreshAndFindFileByNioFile(basePath);
            Intrinsics.checkNotNull((Object)virtualFile);
            return virtualFile;
        }
        return baseDir;
    }

    @JvmStatic
    @NotNull
    public static final VirtualFile createChildDirectory(@NotNull VirtualFile dir, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = WriteAction.computeAndWait((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(dir, name){
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ String $name;

            public final VirtualFile compute() {
                return this.$dir.createChildDirectory(null, this.$name);
            }
            {
                this.$dir = virtualFile;
                this.$name = string;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WriteAction.computeAndWa\u2026ldDirectory(null, name) }");
        return (VirtualFile)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final VirtualFile createVirtualFileWithEncodingUsingNio(@NotNull String ext, @Nullable byte[] bom, @NotNull String content, @NotNull Charset charset, @NotNull TemporaryDirectory temporaryDirectory) {
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)((Object)temporaryDirectory), (String)"temporaryDirectory");
        Path file2 = TemporaryDirectory.newPath$default(temporaryDirectory, '.' + ext, false, 2, null);
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        Closeable closeable = Files.newByteChannel(file2, new HashSet(CollectionsKt.listOf((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW})), new FileAttribute[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            SeekableByteChannel channel = (SeekableByteChannel)closeable;
            boolean bl3 = false;
            if (bom != null) {
                channel.write(ByteBuffer.wrap(bom));
            }
            int n = channel.write(charset.encode(CharBuffer.wrap(content)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(file2);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private HeavyTestHelper() {
    }

    static {
        HeavyTestHelper heavyTestHelper;
        INSTANCE = heavyTestHelper = new HeavyTestHelper();
    }
}

