/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilderDriver;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenJDOMUtil {
    @Nullable
    public static Element read(VirtualFile file, @Nullable ErrorHandler handler) {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isDisposed()) {
            return null;
        }
        String text = (String)ReadAction.compute(() -> {
            if (!file.isValid()) {
                return null;
            }
            try {
                return VfsUtilCore.loadText((VirtualFile)file);
            }
            catch (IOException e) {
                if (handler != null) {
                    handler.onReadError(e);
                }
                return null;
            }
        });
        return text == null ? null : MavenJDOMUtil.doRead(text, handler);
    }

    @Nullable
    public static Element read(byte[] bytes, @Nullable ErrorHandler handler) {
        return MavenJDOMUtil.doRead(CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset()), handler);
    }

    @Nullable
    private static Element doRead(String text, final ErrorHandler handler) {
        final LinkedList stack = new LinkedList();
        final Element[] result = new Element[]{null};
        XmlBuilderDriver driver = new XmlBuilderDriver((CharSequence)text);
        XmlBuilder builder = new XmlBuilder(){

            public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
            }

            public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                Element parent;
                Element newElement;
                String name = localName.toString();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return XmlBuilder.ProcessingOrder.TAGS;
                }
                try {
                    newElement = new Element(name);
                }
                catch (IllegalNameException e) {
                    newElement = new Element("invalidName");
                }
                Element element = parent = stack.isEmpty() ? null : (Element)stack.getLast();
                if (parent == null) {
                    result[0] = newElement;
                } else {
                    parent.addContent(newElement);
                }
                stack.addLast(newElement);
                return XmlBuilder.ProcessingOrder.TAGS_AND_TEXTS;
            }

            public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                String name = localName.toString();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return;
                }
                Iterator itr = stack.descendingIterator();
                while (itr.hasNext()) {
                    Element element = (Element)itr.next();
                    if (!element.getName().equals(name)) continue;
                    while (stack.removeLast() != element) {
                    }
                    break block0;
                }
            }

            public void textElement(CharSequence text, CharSequence physical, int startoffset, int endoffset) {
                ((Element)stack.getLast()).addContent(JDOMUtil.legalizeText((String)text.toString()));
            }

            public void attribute(CharSequence name, CharSequence value, int startoffset, int endoffset) {
            }

            public void entityRef(CharSequence ref, int startOffset, int endOffset) {
            }

            public void error(@NotNull String message, int startOffset, int endOffset) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (handler != null) {
                    handler.onSyntaxError();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/idea/maven/utils/MavenJDOMUtil$1", "error"));
            }
        };
        driver.build(builder);
        return result[0];
    }

    @Nullable
    public static Element findChildByPath(@Nullable Element element, String path) {
        int i = 0;
        while (element != null) {
            int dot = path.indexOf(46, i);
            if (dot == -1) {
                return element.getChild(path.substring(i));
            }
            element = element.getChild(path.substring(i, dot));
            i = dot + 1;
        }
        return null;
    }

    public static String findChildValueByPath(@Nullable Element element, String path, String defaultValue) {
        Element child = MavenJDOMUtil.findChildByPath(element, path);
        if (child == null) {
            return defaultValue;
        }
        String childValue = child.getTextTrim();
        return childValue.isEmpty() ? defaultValue : childValue;
    }

    public static String findChildValueByPath(@Nullable Element element, String path) {
        return MavenJDOMUtil.findChildValueByPath(element, path, null);
    }

    public static boolean hasChildByPath(@Nullable Element element, String path) {
        return MavenJDOMUtil.findChildByPath(element, path) != null;
    }

    public static List<Element> findChildrenByPath(@Nullable Element element, String path, String subPath) {
        return MavenJDOMUtil.collectChildren(MavenJDOMUtil.findChildByPath(element, path), subPath);
    }

    public static List<String> findChildrenValuesByPath(@Nullable Element element, String path, String childrenName) {
        ArrayList<String> result = new ArrayList<String>();
        for (Element each : MavenJDOMUtil.findChildrenByPath(element, path, childrenName)) {
            String value = each.getTextTrim();
            if (value.isEmpty()) continue;
            result.add(value);
        }
        return result;
    }

    private static List<Element> collectChildren(@Nullable Element container, String subPath) {
        if (container == null) {
            return Collections.emptyList();
        }
        int firstDot = subPath.indexOf(46);
        if (firstDot == -1) {
            return container.getChildren(subPath);
        }
        String childName = subPath.substring(0, firstDot);
        String pathInChild = subPath.substring(firstDot + 1);
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element each : container.getChildren(childName)) {
            Element child = MavenJDOMUtil.findChildByPath(each, pathInChild);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }

    public static interface ErrorHandler {
        public void onReadError(IOException var1);

        public void onSyntaxError();
    }
}

