/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenSettingsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.maven"})
public final class MavenSettingsCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "build.maven.state";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        MavenRunnerSettings runnerSettings;
        MavenImportingSettings importingSettings;
        boolean bl;
        boolean bl2;
        CharSequence mavenVersion2;
        MavenGeneralSettings generalSettings;
        MavenProjectsManager manager;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MavenProjectsManager mavenProjectsManager = manager = MavenProjectsManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"manager");
        if (!mavenProjectsManager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        boolean bl3 = false;
        Set usages = new LinkedHashSet();
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasMavenProject", (boolean)true));
        MavenGeneralSettings mavenGeneralSettings = generalSettings = manager.getGeneralSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenGeneralSettings, (String)"generalSettings");
        usages.add(MetricEventFactoryKt.newMetric((String)"checksumPolicy", (Enum)mavenGeneralSettings.getChecksumPolicy()));
        usages.add(MetricEventFactoryKt.newMetric((String)"failureBehavior", (Enum)generalSettings.getFailureBehavior()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"alwaysUpdateSnapshots", (boolean)generalSettings.isAlwaysUpdateSnapshots()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"nonRecursive", (boolean)generalSettings.isNonRecursive()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"printErrorStackTraces", (boolean)generalSettings.isPrintErrorStackTraces()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"usePluginRegistry", (boolean)generalSettings.isUsePluginRegistry()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"workOffline", (boolean)generalSettings.isWorkOffline()));
        usages.add(MetricEventFactoryKt.newMetric((String)"outputLevel", (Enum)generalSettings.getOutputLevel()));
        usages.add(MetricEventFactoryKt.newMetric((String)"pluginUpdatePolicy", (Enum)generalSettings.getPluginUpdatePolicy()));
        usages.add(MetricEventFactoryKt.newMetric((String)"loggingLevel", (Enum)generalSettings.getLoggingLevel()));
        try {
            String string;
            block7: {
                block6: {
                    mavenVersion2 = MavenUtil.getMavenVersion(MavenExternalParameters.resolveMavenHome(generalSettings, project, null));
                    string = mavenVersion2;
                    if (string == null) break block6;
                    String string2 = string;
                    bl2 = false;
                    bl = false;
                    String it = string2;
                    boolean bl4 = false;
                    Version version = Version.parseVersion((String)it);
                    string = version != null ? version.toCompactString() : null;
                    if (string != null) break block7;
                }
                string = "unknown";
            }
            mavenVersion2 = string;
            usages.add(MetricEventFactoryKt.newMetric((String)"mavenVersion", (String)mavenVersion2));
        }
        catch (Exception mavenVersion2) {
            // empty catch block
        }
        String string = generalSettings.getLocalRepository();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generalSettings.localRepository");
        mavenVersion2 = string;
        boolean bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"localRepository", (!StringsKt.isBlank((CharSequence)mavenVersion2) ? 1 : 0) != 0));
        String string3 = generalSettings.getUserSettingsFile();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generalSettings.userSettingsFile");
        mavenVersion2 = string3;
        bl5 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"userSettingsFile", (!StringsKt.isBlank((CharSequence)mavenVersion2) ? 1 : 0) != 0));
        MavenImportingSettings mavenImportingSettings = importingSettings = manager.getImportingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenImportingSettings, (String)"importingSettings");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"lookForNested", (boolean)mavenImportingSettings.isLookForNested()));
        String string4 = importingSettings.getDedicatedModuleDir();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"importingSettings.dedicatedModuleDir");
        Object object = string4;
        bl2 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"dedicatedModuleDir", (!StringsKt.isBlank((CharSequence)object) ? 1 : 0) != 0));
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)externalStorageConfigurationManager, (String)"ExternalStorageConfigura\u2026ager.getInstance(project)");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"storeProjectFilesExternally", (boolean)externalStorageConfigurationManager.isEnabled()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"autoDetectCompiler", (boolean)importingSettings.isAutoDetectCompiler()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModulesForAggregators", (boolean)importingSettings.isCreateModulesForAggregators()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"createModuleGroups", (boolean)importingSettings.isCreateModuleGroups()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"keepSourceFolders", (boolean)importingSettings.isKeepSourceFolders()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"excludeTargetFolder", (boolean)importingSettings.isExcludeTargetFolder()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"useMavenOutput", (boolean)importingSettings.isUseMavenOutput()));
        usages.add(MetricEventFactoryKt.newMetric((String)"generatedSourcesFolder", (Enum)importingSettings.getGeneratedSourcesFolder()));
        String string5 = importingSettings.getUpdateFoldersOnImportPhase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"importingSettings.updateFoldersOnImportPhase");
        usages.add(MetricEventFactoryKt.newMetric((String)"updateFoldersOnImportPhase", (String)string5));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"downloadDocsAutomatically", (boolean)importingSettings.isDownloadDocsAutomatically()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"downloadSourcesAutomatically", (boolean)importingSettings.isDownloadSourcesAutomatically()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"customDependencyTypes", (boolean)(Intrinsics.areEqual((Object)"jar, test-jar, maven-plugin, ejb, ejb-client, jboss-har, jboss-sar, war, ear, bundle", (Object)importingSettings.getDependencyTypes()) ^ true)));
        usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("jdkTypeForImporter", importingSettings.getJdkForImporter()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project, "jdkVersionForImporter", importingSettings.getJdkForImporter()));
        String string6 = importingSettings.getVmOptionsForImporter();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"importingSettings.vmOptionsForImporter");
        object = string6;
        bl2 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasVmOptionsForImporter", (!StringsKt.isBlank((CharSequence)object) ? 1 : 0) != 0));
        List<String> list = manager.getIgnoredFilesPaths();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.ignoredFilesPaths");
        object = list;
        bl2 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasIgnoredFiles", (!object.isEmpty() ? 1 : 0) != 0));
        List<String> list2 = manager.getIgnoredFilesPatterns();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.ignoredFilesPatterns");
        object = list2;
        bl2 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasIgnoredPatterns", (!object.isEmpty() ? 1 : 0) != 0));
        MavenRunner mavenRunner = MavenRunner.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunner, (String)"MavenRunner.getInstance(project)");
        MavenRunnerSettings mavenRunnerSettings = runnerSettings = mavenRunner.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerSettings, (String)"runnerSettings");
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"delegateBuildRun", (boolean)mavenRunnerSettings.isDelegateBuildToMaven()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"runMavenInBackground", (boolean)runnerSettings.isRunMavenInBackground()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJRETypeUsage("runnerJreType", runnerSettings.getJreName()));
        usages.add(ExternalSystemUsagesCollector.Companion.getJREVersionUsage(project, "runnerJreVersion", runnerSettings.getJreName()));
        String string7 = runnerSettings.getVmOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"runnerSettings.vmOptions");
        Map<String, String> map = string7;
        bl = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerVmOptions", (!StringsKt.isBlank((CharSequence)((Object)map)) ? 1 : 0) != 0));
        map = runnerSettings.getEnvironmentProperties();
        bl = false;
        boolean bl6 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerEnvVariables", (!(map == null || map.isEmpty()) ? 1 : 0) != 0));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"passParentEnv", (boolean)runnerSettings.isPassParentEnv()));
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"skipTests", (boolean)runnerSettings.isSkipTests()));
        map = runnerSettings.getMavenProperties();
        bl = false;
        bl6 = false;
        usages.add(MetricEventFactoryKt.newBooleanMetric((String)"hasRunnerMavenProperties", (!(map == null || map.isEmpty()) ? 1 : 0) != 0));
        return usages;
    }
}

